/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.thread;

import com.fusesource.ide.jvmmonitor.core.IThreadElement;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Tree;

public class ThreadComparator
extends ViewerComparator {
    private int sortDirection;
    private int columnIndex;

    public ThreadComparator(int columnIndex) {
        this.columnIndex = columnIndex;
        this.sortDirection = columnIndex == 0 ? 128 : 1024;
    }

    public int compare(Viewer treeViewer, Object e1, Object e2) {
        int result = 0;
        if (!(e1 instanceof IThreadElement && e2 instanceof IThreadElement && treeViewer instanceof TreeViewer)) {
            return result;
        }
        IThreadElement element1 = (IThreadElement)e1;
        IThreadElement element2 = (IThreadElement)e2;
        Tree tree = ((TreeViewer)treeViewer).getTree();
        if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.THREAD)) {
            result = super.compare(treeViewer, (Object)element1.getThreadName(), (Object)element2.getThreadName());
        } else if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.STATE)) {
            String state1 = element1.getThreadState().name();
            String state2 = element2.getThreadState().name();
            if (element1.isDeadlocked()) {
                state1 = "DEADLOCKED";
            }
            if (element2.isDeadlocked()) {
                state2 = "DEADLOCKED";
            }
            result = super.compare(treeViewer, (Object)state1, (Object)state2);
        } else if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.CPU)) {
            result = element1.getCpuUsage() > element2.getCpuUsage() ? 1 : -1;
        } else if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.BLOCKED_TIME)) {
            long time2;
            long time1 = element1.getBlockedTime();
            result = time1 > (time2 = element2.getBlockedTime()) ? 1 : -1;
        } else if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.BLOCKED_COUNT)) {
            long count2;
            long count1 = element1.getBlockedCount();
            result = count1 > (count2 = element2.getBlockedCount()) ? 1 : -1;
        } else if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.WAITED_TIME)) {
            long time2;
            long time1 = element1.getWaitedTime();
            result = time1 > (time2 = element2.getWaitedTime()) ? 1 : -1;
        } else if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.WAITED_COUNT)) {
            long count2;
            long count1 = element1.getWaitedCount();
            result = count1 > (count2 = element2.getWaitedCount()) ? 1 : -1;
        } else if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.LOCK)) {
            result = super.compare(treeViewer, (Object)element1.getLockName(), (Object)element2.getLockName());
        } else if (this.columnIndex == this.getColumnIndex(tree, ThreadColumn.LOCK_OWNWER)) {
            result = super.compare(treeViewer, (Object)element1.getLockOwnerName(), (Object)element2.getLockOwnerName());
        }
        if (this.sortDirection == 1024) {
            result *= -1;
        }
        return result;
    }

    protected void reverseSortDirection() {
        this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
    }

    protected int getSortDirection() {
        return this.sortDirection;
    }

    protected int getColumnIndex() {
        return this.columnIndex;
    }

    private int getColumnIndex(Tree tree, ThreadColumn column) {
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

