/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.eclipse.swt.graphics.RGB;

public class AttributeNode {
    private String name;
    private List<AttributeNode> children;
    private AttributeNode parent;
    private boolean validLeaf;
    private ObjectName objectName;
    private RGB rgb;

    public AttributeNode(String name, AttributeNode parent) {
        this(name, parent, parent.getObjectName());
    }

    public AttributeNode(String name, AttributeNode parent, ObjectName objectName) {
        this.name = name;
        this.parent = parent;
        this.objectName = objectName;
        this.validLeaf = false;
        this.children = new ArrayList<AttributeNode>();
        this.rgb = new RGB(0, 0, 255);
    }

    protected String getName() {
        return this.name;
    }

    protected ObjectName getObjectName() {
        return this.objectName;
    }

    protected void addChild(AttributeNode node) {
        this.children.add(node);
    }

    protected List<AttributeNode> getChildren() {
        return this.children;
    }

    protected boolean hasChildren() {
        return this.children.size() > 0;
    }

    protected void remove() {
        if (this.parent == null) {
            return;
        }
        this.parent.getChildren().remove(this);
        if (this.parent.getChildren().size() == 0) {
            this.parent.remove();
        }
    }

    protected void setValidLeaf(boolean validLeaf) {
        this.validLeaf = validLeaf;
    }

    protected boolean isValidLeaf() {
        return this.validLeaf;
    }

    protected void setRgb(RGB rgb) {
        this.rgb = rgb;
    }

    protected RGB getRgb() {
        return this.rgb;
    }

    protected String getQualifiedName() {
        String qualifiedName = this.name;
        AttributeNode node = this;
        while (node.parent != null) {
            node = node.parent;
            qualifiedName = String.valueOf(node.getName()) + "." + qualifiedName;
        }
        return qualifiedName;
    }
}

