/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanAttribute;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.ConfigureChartDialog;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.TimelineChart;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.RGB;

public class ConfigureChartAction
extends Action {
    private TimelineChart chart;
    private AbstractJvmPropertySection section;

    public ConfigureChartAction(TimelineChart chart, AbstractJvmPropertySection section) {
        this.chart = chart;
        this.section = section;
        this.setText(Messages.configureChartLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/configure.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm == null) {
            return;
        }
        String title = this.chart.getSection().getText();
        IMonitoredMXBeanGroup group = this.chart.getAttributeGroup();
        IMonitoredMXBeanGroup.AxisUnit unit = group.getAxisUnit();
        List<MBeanAttribute> attributes = this.getAttributes();
        ConfigureChartDialog dialog = new ConfigureChartDialog(this.chart.getShell(), title, unit, attributes, jvm, true);
        if (dialog.open() == 0) {
            this.performConfiguration(dialog.getChartTitle(), dialog.getAxisUnit(), dialog.getAttributes(), dialog.getRemovedAttributes());
        }
    }

    private void performConfiguration(String chartTitle, IMonitoredMXBeanGroup.AxisUnit axisUnit, List<MBeanAttribute> attributes, List<MBeanAttribute> removedAttributes) {
        IMonitoredMXBeanGroup group = this.chart.getAttributeGroup();
        group.setName(chartTitle);
        group.setAxisUnit(axisUnit);
        for (MBeanAttribute attribute : attributes) {
            ObjectName objectName = attribute.getObjectName();
            String attributeName = attribute.getAttributeName();
            IMonitoredMXBeanAttribute monitoredAttribute = group.getAttribute(objectName, attributeName);
            RGB rgb = attribute.getRgb();
            if (monitoredAttribute == null) {
                try {
                    group.addAttribute(objectName.getCanonicalName(), attributeName, new int[]{rgb.red, rgb.green, rgb.blue});
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.addAttributeFailedMsg, (CoreException)((Object)e));
                }
                continue;
            }
            monitoredAttribute.setRGB(rgb.red, rgb.green, rgb.blue);
        }
        for (MBeanAttribute removedAttribute : removedAttributes) {
            group.removeAttribute(removedAttribute.getObjectName().getCanonicalName(), removedAttribute.getAttributeName());
        }
        this.chart.refresh();
    }

    private List<MBeanAttribute> getAttributes() {
        ArrayList<MBeanAttribute> attributes = new ArrayList<MBeanAttribute>();
        for (IMonitoredMXBeanAttribute attribute : this.chart.getAttributeGroup().getAttributes()) {
            ObjectName objectName = attribute.getObjectName();
            String attributeName = attribute.getAttributeName();
            int[] rgb = attribute.getRGB();
            attributes.add(new MBeanAttribute(objectName, attributeName, new RGB(rgb[0], rgb[1], rgb[2])));
        }
        return attributes;
    }
}

