/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.AttributeSelectionDialog;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttributeColumn;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttributeContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttributeLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class ConfigureChartDialog
extends Dialog {
    Text chartTitleText;
    private Combo axisUnitCombo;
    TreeViewer attributesViewer;
    private ColorSelector colorSelector;
    private String chartTitle;
    private final String originalChartTitle;
    private IMonitoredMXBeanGroup.AxisUnit unit;
    private List<MBeanAttribute> attributes;
    private List<MBeanAttribute> removedAttributes;
    private IActiveJvm jvm;
    private Button removeButton;
    private boolean hasAddRemoveButtons;
    private Image errorImage;
    private Label errorImageLabel;
    private Label errorMessageLabel;

    protected ConfigureChartDialog(Shell shell, String chartTitle, IMonitoredMXBeanGroup.AxisUnit unit, List<MBeanAttribute> attributes, IActiveJvm jvm, boolean hasAddRemoveButtons) {
        super(shell);
        this.chartTitle = chartTitle;
        this.originalChartTitle = chartTitle;
        this.unit = unit;
        this.attributes = attributes;
        this.jvm = jvm;
        this.hasAddRemoveButtons = hasAddRemoveButtons;
        this.removedAttributes = new ArrayList<MBeanAttribute>();
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.configureChartDialogTitle);
        this.setOkButtonVisible(!this.chartTitleText.getText().isEmpty());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "com.fusesource.ide.jvmmonitor.ui.configure_chart_dialog_content");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createChartConfigControls(container);
        this.createSeriesConfigControls(container);
        this.createErrorMessageControls(container);
        ConfigureChartDialog.applyDialogFont((Control)container);
        return container;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.chartTitle = this.chartTitleText.getText();
        IMonitoredMXBeanGroup.AxisUnit[] values = IMonitoredMXBeanGroup.AxisUnit.values();
        int selectionIndex = this.axisUnitCombo.getSelectionIndex();
        if (selectionIndex < values.length) {
            this.unit = values[selectionIndex];
        }
        super.okPressed();
    }

    public boolean close() {
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        return super.close();
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public IMonitoredMXBeanGroup.AxisUnit getAxisUnit() {
        return this.unit;
    }

    public List<MBeanAttribute> getAttributes() {
        return this.attributes;
    }

    protected List<MBeanAttribute> getRemovedAttributes() {
        return this.removedAttributes;
    }

    private void createChartConfigControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(Messages.chartTitleLabel);
        this.chartTitleText = new Text(composite, 2048);
        this.chartTitleText.setLayoutData((Object)new GridData(768));
        this.chartTitleText.setText(this.chartTitle);
        this.chartTitleText.setSelection(0, this.chartTitle.length());
        this.chartTitleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureChartDialog.this.validate(ConfigureChartDialog.this.chartTitleText.getText());
            }
        });
        new Label(composite, 0).setText(Messages.yAxisUnitLabel);
        this.axisUnitCombo = new Combo(composite, 8);
        ArrayList<String> items = new ArrayList<String>();
        int initialSelection = -1;
        IMonitoredMXBeanGroup.AxisUnit[] values = IMonitoredMXBeanGroup.AxisUnit.values();
        int i = 0;
        while (i < values.length) {
            items.add(values[i].name());
            if (values[i] == this.unit) {
                initialSelection = i;
            }
            ++i;
        }
        this.axisUnitCombo.setItems(items.toArray(new String[items.size()]));
        if (initialSelection == -1) {
            initialSelection = items.size() - 1;
        }
        this.axisUnitCombo.select(initialSelection);
        this.axisUnitCombo.setLayoutData((Object)new GridData(768));
    }

    private void createSeriesConfigControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.monitoredAttributesLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.attributesViewer = this.createAttributesViewer(composite);
        this.createButtons(composite);
        if (this.attributes.size() > 0) {
            this.attributesViewer.setSelection((ISelection)new StructuredSelection((Object)this.attributes.get(0)));
        }
    }

    private void createErrorMessageControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.errorImageLabel = new Label(composite, 0);
        this.errorImageLabel.setImage(this.getErrorImage());
        this.errorImageLabel.setVisible(false);
        this.errorMessageLabel = new Label(composite, 72);
        this.errorMessageLabel.setLayoutData((Object)new GridData(768));
    }

    private TreeViewer createAttributesViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 67584);
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.setContentProvider((IContentProvider)new MBeanAttributeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanAttributeLabelProvider(viewer));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigureChartDialog.this.viewerSlectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.configureTree(viewer.getTree());
        viewer.setInput((Object)this.attributes.toArray(new MBeanAttribute[this.attributes.size()]));
        return viewer;
    }

    private void configureTree(Tree tree) {
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        MBeanAttributeColumn[] mBeanAttributeColumnArray = MBeanAttributeColumn.values();
        int n = mBeanAttributeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanAttributeColumn column = mBeanAttributeColumnArray[n2];
            TreeColumn treeColumn = new TreeColumn(tree, 0);
            treeColumn.setText(column.label);
            treeColumn.setWidth(column.defalutWidth);
            treeColumn.setAlignment(column.alignment);
            treeColumn.setToolTipText(column.toolTip);
            ++n2;
        }
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        if (this.hasAddRemoveButtons) {
            this.createAddButton(composite);
            this.createRemoveButton(composite);
        }
        new Label(composite, 0).setText(Messages.colorLabel);
        this.colorSelector = this.createColorSelector(composite);
    }

    private void createAddButton(Composite parent) {
        Button addButton = new Button(parent, 8);
        addButton.setText(Messages.addButtonLabel);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        addButton.setLayoutData((Object)gridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureChartDialog.this.addAttributes();
            }
        });
    }

    void addAttributes() {
        AttributeSelectionDialog dialog = new AttributeSelectionDialog(this.getShell(), this.jvm);
        if (dialog.open() == 0) {
            List<MBeanAttribute> selectedAttributes = dialog.getSelectedAttributes();
            if (selectedAttributes.size() == 0) {
                return;
            }
            this.attributes.addAll(selectedAttributes);
            this.attributesViewer.setInput((Object)this.attributes.toArray(new MBeanAttribute[this.attributes.size()]));
            this.attributesViewer.setSelection((ISelection)new StructuredSelection((Object)selectedAttributes.get(0)), true);
        }
    }

    private void createRemoveButton(Composite parent) {
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText(Messages.removeButtonLabel);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selectedAttribute = (IStructuredSelection)ConfigureChartDialog.this.attributesViewer.getSelection();
                MBeanAttribute attribute = (MBeanAttribute)selectedAttribute.getFirstElement();
                ConfigureChartDialog.this.removeAttribute(attribute);
            }
        });
    }

    private ColorSelector createColorSelector(Composite parent) {
        final ColorSelector selector = new ColorSelector(parent);
        selector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ConfigureChartDialog.this.attributesViewer.getSelection();
                MBeanAttribute attribute = (MBeanAttribute)selection.getFirstElement();
                if (attribute != null) {
                    attribute.setRgb(selector.getColorValue());
                }
            }
        });
        selector.setEnabled(false);
        return selector;
    }

    void viewerSlectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            if (this.removeButton != null) {
                this.removeButton.setEnabled(false);
            }
            this.colorSelector.setEnabled(false);
            return;
        }
        MBeanAttribute attribute = (MBeanAttribute)selection.getFirstElement();
        if (this.removeButton != null) {
            this.removeButton.setEnabled(true);
        }
        this.colorSelector.setEnabled(true);
        this.colorSelector.setColorValue(attribute.getRgb());
    }

    void removeAttribute(MBeanAttribute attribute) {
        this.attributes.remove(attribute);
        this.attributesViewer.setInput((Object)this.attributes.toArray(new MBeanAttribute[this.attributes.size()]));
        this.removedAttributes.add(attribute);
        if (this.attributes.size() > 0) {
            this.attributesViewer.setSelection((ISelection)new StructuredSelection((Object)this.attributes.get(0)));
        }
    }

    void validate(String text) {
        String errorMessage = "";
        for (IMonitoredMXBeanGroup group : this.jvm.getMBeanServer().getMonitoredAttributeGroups()) {
            if (!group.getName().equals(text) || this.originalChartTitle.equals(text)) continue;
            errorMessage = Messages.chartTitleDuplicatedMsg;
            break;
        }
        if (text.isEmpty()) {
            errorMessage = Messages.chartTitleEmptyMsg;
        }
        this.errorImageLabel.setVisible(!errorMessage.isEmpty());
        this.errorMessageLabel.setText(errorMessage);
        this.setOkButtonVisible(errorMessage.isEmpty());
    }

    private void setOkButtonVisible(boolean visible) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(visible);
        }
    }

    private Image getErrorImage() {
        if (this.errorImage == null || this.errorImage.isDisposed()) {
            this.errorImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK").createImage();
        }
        return this.errorImage;
    }
}

