/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.mbean.IMBeanServer;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.AbstractChartSetAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.LoadChartSetDialog;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class LoadChartSetAction
extends AbstractChartSetAction {
    private static final String[] NON_HEAP_MEMORYPOOL_MXBEANS = new String[]{"name=.*Code Cache", "name=.*Perm Gen"};
    private static final String[] HEAP_MEMORYPOOL_MXBEANS = new String[]{"name=.*Eden Space", "name=.*Survivor Space", "name=.*Tenured Gen", "name=.*Old Gen"};

    public LoadChartSetAction(AbstractJvmPropertySection section) {
        super(section);
        this.setText(Messages.loadChartSetLabel);
    }

    public void run() {
        LoadChartSetDialog dialog;
        try {
            dialog = new LoadChartSetDialog(this.section.getPart().getSite().getShell(), this.getChartSets(), this.getDefaultChartSet(), this.getPredefinedChartSets());
        }
        catch (WorkbenchException e) {
            Activator.log(4, Messages.openSaveChartSetAsDialogFailedMsg, e);
            return;
        }
        catch (IOException e) {
            Activator.log(4, Messages.openSaveChartSetAsDialogFailedMsg, e);
            return;
        }
        if (dialog.open() == 0) {
            try {
                this.saveChartSets(dialog.getChartSets());
                this.loadChartSet(dialog.getChartSet());
            }
            catch (WorkbenchException e) {
                Activator.log(4, Messages.loadChartSetFailedMsg, e);
            }
            catch (IOException e) {
                Activator.log(4, Messages.loadChartSetFailedMsg, e);
            }
            catch (JvmCoreException e) {
                Activator.log(4, Messages.loadChartSetFailedMsg, e);
            }
            this.storeDefaultChartSet(dialog.getDefaultChartSet());
        }
    }

    protected void loadDefaultChartSet() throws JvmCoreException {
        try {
            this.loadChartSet(this.getDefaultChartSet());
        }
        catch (WorkbenchException e) {
            Activator.log(4, Messages.loadChartSetFailedMsg, e);
        }
        catch (IOException e) {
            Activator.log(4, Messages.loadChartSetFailedMsg, e);
        }
    }

    private void storeDefaultChartSet(String defaultChartSet) {
        Activator.getDefault().getPreferenceStore().setValue("DefaultChartSet", defaultChartSet);
    }

    private String getDefaultChartSet() throws WorkbenchException, IOException {
        String defaultChartSet = Activator.getDefault().getPreferenceStore().getString("DefaultChartSet");
        List<String> chartSets = this.getChartSets();
        if (defaultChartSet.isEmpty() || !chartSets.contains(defaultChartSet)) {
            Activator.getDefault().getPreferenceStore().setDefault("DefaultChartSet", "Overview");
            defaultChartSet = "Overview";
        }
        return defaultChartSet;
    }

    @Override
    List<String> getChartSets() throws WorkbenchException, IOException {
        List<String> elements = super.getChartSets();
        elements.add(0, "Overview");
        elements.add(1, "Memory");
        return elements;
    }

    private void loadChartSet(String chartSet) throws JvmCoreException {
        IMemento[] mementos;
        IMemento chartSetsMemento;
        this.loadPredefinedChartSet(chartSet);
        try {
            chartSetsMemento = this.getChartSetsMemento();
        }
        catch (WorkbenchException e) {
            throw new JvmCoreException(4, Messages.loadChartSetFailedMsg, (Throwable)e);
        }
        catch (IOException e) {
            throw new JvmCoreException(4, Messages.loadChartSetFailedMsg, (Throwable)e);
        }
        if (chartSetsMemento == null) {
            return;
        }
        IMemento[] iMementoArray = mementos = chartSetsMemento.getChildren("ChartSet");
        int n = mementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (chartSet.equals(memento.getID())) {
                this.loadChartSet(memento);
                return;
            }
            ++n2;
        }
    }

    private void loadChartSet(IMemento memento) throws JvmCoreException {
        IMBeanServer server = this.section.getJvm().getMBeanServer();
        server.getMonitoredAttributeGroups().clear();
        StringBuffer buffer = new StringBuffer();
        IMemento[] iMementoArray = memento.getChildren("Group");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento groupMemento = iMementoArray[n2];
            IMonitoredMXBeanGroup group = server.addMonitoredAttributeGroup(groupMemento.getID(), IMonitoredMXBeanGroup.AxisUnit.valueOf((String)groupMemento.getString("Unit")));
            IMemento[] iMementoArray2 = groupMemento.getChildren("Attribute");
            int n3 = iMementoArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String attributeName;
                IMemento attributeMemento = iMementoArray2[n4];
                String objectName = attributeMemento.getString("ObjectName");
                if (this.attributeExist(objectName, attributeName = attributeMemento.getID())) {
                    group.addAttribute(objectName, attributeName, this.getRGB(attributeMemento.getString("Color")));
                } else {
                    buffer.append('\n');
                    buffer.append(String.valueOf(objectName) + ':' + attributeName);
                }
                ++n4;
            }
            ++n2;
        }
        if (buffer.length() > 0) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.errorDialogTitle, (String)NLS.bind((String)Messages.attributeNotSupportedMsg, (Object)buffer.toString()));
        }
    }

    private boolean attributeExist(String objectName, String attributeName) {
        IMBeanServer server = this.section.getJvm().getMBeanServer();
        try {
            server.getAttribute(ObjectName.getInstance(objectName), attributeName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (JvmCoreException jvmCoreException) {
            return false;
        }
        return true;
    }

    private void loadPredefinedChartSet(String chartSet) throws JvmCoreException {
        if ("Overview".equals(chartSet)) {
            this.loadOverviewChartSet();
        } else if ("Memory".equals(chartSet)) {
            this.loadMemoryChartSet();
        }
    }

    private void loadOverviewChartSet() throws JvmCoreException {
        int[] nArray = new int[3];
        nArray[2] = 255;
        int[] blue = nArray;
        IMBeanServer server = this.section.getJvm().getMBeanServer();
        server.getMonitoredAttributeGroups().clear();
        IMonitoredMXBeanGroup group = server.addMonitoredAttributeGroup("Used Heap Memory", IMonitoredMXBeanGroup.AxisUnit.MBytes);
        group.addAttribute("java.lang:type=Memory", "HeapMemoryUsage.used", blue);
        group = server.addMonitoredAttributeGroup("Loaded Class Count", IMonitoredMXBeanGroup.AxisUnit.Count);
        group.addAttribute("java.lang:type=ClassLoading", "LoadedClassCount", blue);
        group = server.addMonitoredAttributeGroup("Thread Count", IMonitoredMXBeanGroup.AxisUnit.Count);
        group.addAttribute("java.lang:type=Threading", "ThreadCount", blue);
        group = server.addMonitoredAttributeGroup("CPU Usage", IMonitoredMXBeanGroup.AxisUnit.Percent);
        group.addAttribute("java.lang:type=OperatingSystem", "ProcessCpuTime", blue);
    }

    private void loadMemoryChartSet() throws JvmCoreException {
        int[] nArray = new int[3];
        nArray[2] = 255;
        int[] blue = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 255;
        int[] green = nArray2;
        IMBeanServer server = this.section.getJvm().getMBeanServer();
        server.getMonitoredAttributeGroups().clear();
        IMonitoredMXBeanGroup group = server.addMonitoredAttributeGroup("Heap Memory", IMonitoredMXBeanGroup.AxisUnit.MBytes);
        group.addAttribute("java.lang:type=Memory", "HeapMemoryUsage.used", blue);
        group.addAttribute("java.lang:type=Memory", "HeapMemoryUsage.committed", green);
        group = server.addMonitoredAttributeGroup("Non-Heap Memory", IMonitoredMXBeanGroup.AxisUnit.MBytes);
        group.addAttribute("java.lang:type=Memory", "NonHeapMemoryUsage.used", blue);
        group.addAttribute("java.lang:type=Memory", "NonHeapMemoryUsage.committed", green);
        group = server.addMonitoredAttributeGroup("Heap Memory Pool", IMonitoredMXBeanGroup.AxisUnit.MBytes);
        for (String objectName : this.getMemoryPoolObjectNames(HEAP_MEMORYPOOL_MXBEANS)) {
            group.addAttribute(objectName, "Usage.used", blue);
        }
        group = server.addMonitoredAttributeGroup("Non-Heap Memory Pool", IMonitoredMXBeanGroup.AxisUnit.MBytes);
        for (String objectName : this.getMemoryPoolObjectNames(NON_HEAP_MEMORYPOOL_MXBEANS)) {
            group.addAttribute(objectName, "Usage.used", blue);
        }
    }

    private Set<String> getMemoryPoolObjectNames(String[] filters) throws JvmCoreException {
        HashSet<String> objectNames = new HashSet<String>();
        try {
            for (ObjectName objectName : this.section.getJvm().getMBeanServer().queryNames(ObjectName.getInstance("java.lang:type=MemoryPool,name=*"))) {
                String canonicalName = objectName.getCanonicalName();
                String[] stringArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    String filter = stringArray[n2];
                    if (Pattern.compile(filter).matcher(canonicalName).find()) {
                        objectNames.add(canonicalName);
                    }
                    ++n2;
                }
            }
        }
        catch (MalformedObjectNameException e) {
            Activator.log(4, Messages.getMemoryPoolAttributeFailedMsg, e);
        }
        catch (NullPointerException e) {
            Activator.log(4, Messages.getMemoryPoolAttributeFailedMsg, e);
        }
        return objectNames;
    }

    private void saveChartSets(List<String> chartSets) throws WorkbenchException, IOException {
        IMemento oldChartSetsMemento = this.getChartSetsMemento();
        IMemento[] oldMementos = oldChartSetsMemento == null ? new IMemento[]{} : oldChartSetsMemento.getChildren("ChartSet");
        XMLMemento chartSetsMemento = XMLMemento.createWriteRoot((String)"ChartSets");
        block0: for (String chartSet : chartSets) {
            IMemento[] iMementoArray = oldMementos;
            int n = oldMementos.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento memento = iMementoArray[n2];
                if (chartSet.equals(memento.getID())) {
                    chartSetsMemento.createChild("ChartSet").putMemento(memento);
                    continue block0;
                }
                ++n2;
            }
        }
        StringWriter writer = new StringWriter();
        chartSetsMemento.save((Writer)writer);
        Activator.getDefault().getPreferenceStore().setValue("ChartSets", writer.getBuffer().toString());
    }

    private int[] getRGB(String rgbString) {
        String[] elements = rgbString.split(",");
        int[] rgb = new int[3];
        int i = 0;
        while (i < rgb.length) {
            rgb[i] = Integer.valueOf(elements[i]);
            ++i;
        }
        return rgb;
    }
}

