/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.TimelineChart;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.swtchart.ISeries;

public class Marker {
    private static final int MARGIN = 3;
    private static final int OFFSET = 25;
    private static final String TIME_KEY = "time";
    private TimelineChart chart;
    private Map<String, Shell> hovers;
    Map<String, String> texts;
    private int mouseXPosition;

    public Marker(TimelineChart chart) {
        this.chart = chart;
        this.hovers = new HashMap<String, Shell>();
        this.texts = new HashMap<String, String>();
    }

    protected boolean isDisposed() {
        return this.hovers.isEmpty();
    }

    protected void dispose() {
        this.disposeHovers();
    }

    protected void redraw() {
        if (!this.isDisposed()) {
            this.setPosition(this.mouseXPosition);
        }
    }

    protected void setPosition(int x) {
        this.mouseXPosition = x;
        Integer invertedSeriesIndex = this.getInvertedSeriesIndex(x);
        this.createHovers();
        if (invertedSeriesIndex != null) {
            this.configureHovers(invertedSeriesIndex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createHovers() {
        Shell hover;
        void var3_6;
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(TIME_KEY);
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        boolean n2 = false;
        while (var3_6 < n) {
            ISeries series = iSeriesArray[var3_6];
            keys.add(series.getId());
            ++var3_6;
        }
        HashMap<String, Shell> newHovers = new HashMap<String, Shell>();
        for (String string : keys) {
            hover = this.hovers.get(string);
            if (hover == null) {
                hover = this.createHover(string);
            }
            newHovers.put(string, hover);
        }
        for (Map.Entry entry : this.hovers.entrySet()) {
            if (keys.contains(entry.getKey())) continue;
            hover = (Shell)entry.getValue();
            Region region = hover.getRegion();
            if (region != null) {
                region.dispose();
            }
            hover.dispose();
        }
        this.hovers = newHovers;
    }

    private Shell createHover(final String key) {
        Shell hover = new Shell(Display.getDefault().getActiveShell(), 540684);
        hover.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                String text = Marker.this.texts.get(key);
                if (text != null) {
                    e.gc.drawText(Marker.this.texts.get(key), 28, 25);
                }
            }
        });
        hover.setBackground(Display.getDefault().getSystemColor(13));
        hover.setAlpha(220);
        return hover;
    }

    private void configureHovers(Integer invertedSeriesIndex) {
        ISeries[] seriesArray = this.chart.getSeriesSet().getSeries();
        Date[] dates = seriesArray[0].getXDateSeries();
        long time = dates[dates.length - invertedSeriesIndex].getTime();
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.timeLabel).append(' ').append(new SimpleDateFormat("HH:mm:ss").format(time));
        this.texts.put(TIME_KEY, buffer.toString());
        int timeInPixel = this.chart.getAxisSet().getXAxes()[0].getPixelCoordinate((double)time);
        this.configureHover(this.hovers.get(TIME_KEY), buffer.toString(), timeInPixel, this.chart.getPlotArea().getSize().y, true);
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            double[] ySeries = series.getYSeries();
            int seriesIndex = ySeries.length - invertedSeriesIndex;
            if (seriesIndex >= 0) {
                buffer = new StringBuffer();
                buffer.append(series.getId()).append(": ").append(this.getFormattedValue(ySeries[seriesIndex]));
                this.texts.put(series.getId(), buffer.toString());
                int valueInPixel = this.chart.getAxisSet().getYAxes()[0].getPixelCoordinate(ySeries[seriesIndex]);
                this.configureHover(this.hovers.get(series.getId()), buffer.toString(), timeInPixel, valueInPixel, false);
            }
            ++n2;
        }
    }

    private void configureHover(Shell hover, String text, int x, int y, boolean showBelow) {
        Point textExtent = this.getExtent(hover, text);
        Point hoverSize = new Point(textExtent.x + 6 + 50, textExtent.y + 50);
        hover.setSize(hoverSize);
        boolean showOnRight = Display.getDefault().map((Control)this.chart.getPlotArea(), null, (int)(x + hoverSize.x), (int)y).x < Display.getDefault().getBounds().width;
        int hoverX = showOnRight ? x : x - hoverSize.x;
        int hoverY = showBelow ? y : y - hoverSize.y;
        hover.setLocation(this.chart.getPlotArea().toDisplay(hoverX, hoverY));
        Region region = hover.getRegion();
        if (region != null) {
            region.dispose();
        }
        region = this.getHoverRegion(textExtent, showOnRight, showBelow);
        hover.setRegion(region);
        hover.redraw();
        hover.setVisible(true);
    }

    private Region getHoverRegion(Point textExtent, boolean showOnRight, boolean showBelow) {
        int[] pointArray;
        Region region = new Region();
        if (showOnRight && showBelow) {
            int[] nArray = new int[14];
            nArray[2] = 30;
            nArray[3] = 25;
            nArray[4] = textExtent.x + 6 + 25;
            nArray[5] = 25;
            nArray[6] = textExtent.x + 6 + 25;
            nArray[7] = textExtent.y + 25;
            nArray[8] = 25;
            nArray[9] = textExtent.y + 25;
            nArray[10] = 25;
            nArray[11] = 30;
            pointArray = nArray;
        } else if (!showOnRight && showBelow) {
            int[] nArray = new int[14];
            nArray[0] = 25;
            nArray[1] = 25;
            nArray[2] = textExtent.x + 6 + 25 - 5;
            nArray[3] = 25;
            nArray[4] = textExtent.x + 6 + 50;
            nArray[6] = textExtent.x + 6 + 25;
            nArray[7] = 30;
            nArray[8] = textExtent.x + 6 + 25;
            nArray[9] = textExtent.y + 25;
            nArray[10] = 25;
            nArray[11] = textExtent.y + 25;
            nArray[12] = 25;
            nArray[13] = 25;
            pointArray = nArray;
        } else if (showOnRight && !showBelow) {
            int[] nArray = new int[14];
            nArray[0] = 25;
            nArray[1] = 25;
            nArray[2] = textExtent.x + 6 + 25;
            nArray[3] = 25;
            nArray[4] = textExtent.x + 6 + 25;
            nArray[5] = textExtent.y + 25;
            nArray[6] = 30;
            nArray[7] = textExtent.y + 25;
            nArray[9] = textExtent.y + 50;
            nArray[10] = 25;
            nArray[11] = textExtent.y + 25 - 5;
            nArray[12] = 25;
            nArray[13] = 25;
            pointArray = nArray;
        } else {
            pointArray = new int[]{25, 25, textExtent.x + 6 + 25, 25, textExtent.x + 6 + 25, textExtent.y + 25 - 5, textExtent.x + 6 + 50, textExtent.y + 50, textExtent.x + 6 + 25 - 5, textExtent.y + 25, 25, textExtent.y + 25, 25, 25};
        }
        region.add(pointArray);
        return region;
    }

    private Point getExtent(Shell hover, String text) {
        GC gc = new GC((Drawable)hover);
        Point textExtent = gc.textExtent(text);
        gc.dispose();
        return textExtent;
    }

    private Integer getInvertedSeriesIndex(int desiredX) {
        long desiredTime = (long)this.chart.getAxisSet().getAxes()[0].getDataCoordinate(desiredX);
        ISeries largestSeries = null;
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            int length = series.getXSeries().length;
            if (largestSeries == null || largestSeries.getXSeries().length < length) {
                largestSeries = series;
            }
            ++n2;
        }
        if (largestSeries == null) {
            return null;
        }
        Date[] dates = largestSeries.getXDateSeries();
        int i = 0;
        while (i < dates.length) {
            if (dates[i].getTime() >= desiredTime || i == dates.length - 1) {
                int nearestIndex = i > 0 && dates[i].getTime() - desiredTime > desiredTime - dates[i - 1].getTime() ? i - 1 : i;
                return dates.length - nearestIndex;
            }
            ++i;
        }
        return null;
    }

    private String getFormattedValue(Object value) {
        IMonitoredMXBeanGroup.AxisUnit axisUnit = this.chart.getAttributeGroup().getAxisUnit();
        if (axisUnit == IMonitoredMXBeanGroup.AxisUnit.Percent) {
            return new DecimalFormat("###%").format(value);
        }
        if (axisUnit == IMonitoredMXBeanGroup.AxisUnit.MBytes) {
            return new DecimalFormat("#####.#M").format(value);
        }
        if (axisUnit == IMonitoredMXBeanGroup.AxisUnit.Count) {
            return NumberFormat.getIntegerInstance().format(value);
        }
        return value.toString();
    }

    private void disposeHovers() {
        for (Shell hover : this.hovers.values()) {
            Region region = hover.getRegion();
            if (region != null) {
                region.dispose();
            }
            hover.dispose();
        }
        this.hovers.clear();
        this.texts.clear();
    }
}

