/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SaveChartSetAsDialog
extends Dialog {
    TableViewer chartSetViewer;
    Button deleteButton;
    Text chartSetText;
    private Image errorImage;
    private Label errorImageLabel;
    private Label errorMessageLabel;
    List<String> chartSets;
    String chartSet;
    private List<String> predefinedChartSets;
    protected boolean ignoreSelection;

    protected SaveChartSetAsDialog(Shell shell, List<String> chartSets, List<String> predefinedChartSets) {
        super(shell);
        this.chartSets = chartSets;
        this.chartSet = "";
        this.predefinedChartSets = predefinedChartSets;
        this.ignoreSelection = false;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.saveChartSetAsDialogTitle);
        this.validate();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "com.fusesource.ide.jvmmonitor.ui.save_chart_set_as_dialog_content");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(Messages.enterOrSelectChartSetLabel);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.createChartSetText(container);
        this.createChartSetList(container);
        this.createErrorMessageLabel(container);
        SaveChartSetAsDialog.applyDialogFont((Control)container);
        return container;
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean close() {
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        return super.close();
    }

    protected List<String> getChartSets() {
        return this.chartSets;
    }

    protected String getChartSet() {
        return this.chartSet;
    }

    private void createChartSetText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(Messages.chartSetLabel);
        this.chartSetText = new Text(composite, 2048);
        this.chartSetText.setLayoutData((Object)new GridData(768));
        this.chartSetText.setText(this.chartSet);
        this.chartSetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SaveChartSetAsDialog.this.ignoreSelection = true;
                    SaveChartSetAsDialog.this.chartSet = SaveChartSetAsDialog.this.chartSetText.getText();
                    if (SaveChartSetAsDialog.this.chartSets.contains(SaveChartSetAsDialog.this.chartSet)) {
                        SaveChartSetAsDialog.this.chartSetViewer.setSelection((ISelection)new StructuredSelection((Object)SaveChartSetAsDialog.this.chartSet));
                    } else {
                        SaveChartSetAsDialog.this.deleteButton.setEnabled(false);
                        SaveChartSetAsDialog.this.chartSetViewer.setSelection((ISelection)new StructuredSelection());
                    }
                }
                finally {
                    SaveChartSetAsDialog.this.ignoreSelection = false;
                }
                SaveChartSetAsDialog.this.validate();
            }
        });
    }

    private void createChartSetList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.existingChartSetsLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.chartSetViewer = this.createChartSetViewer(composite);
        this.createDeleteButton(composite);
    }

    private void createDeleteButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        this.deleteButton = new Button(composite, 8);
        this.deleteButton.setText(Messages.deleteButtonLabel);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.deleteButton.setLayoutData((Object)gridData);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SaveChartSetAsDialog.this.chartSetViewer.getSelection();
                String element = (String)selection.getFirstElement();
                SaveChartSetAsDialog.this.chartSets.remove(element);
                SaveChartSetAsDialog.this.chartSetViewer.setInput((Object)SaveChartSetAsDialog.this.chartSets.toArray(new String[SaveChartSetAsDialog.this.chartSets.size()]));
            }
        });
    }

    private TableViewer createChartSetViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 67584);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        viewer.getTable().setLayoutData((Object)gridData);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)this.chartSets.toArray(new String[this.chartSets.size()]));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                if (SaveChartSetAsDialog.this.ignoreSelection) {
                    return;
                }
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) != null) {
                    SaveChartSetAsDialog.this.chartSetText.setText(element.toString());
                    SaveChartSetAsDialog.this.deleteButton.setEnabled(true);
                }
            }
        });
        return viewer;
    }

    private void createErrorMessageLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.errorImageLabel = new Label(composite, 0);
        this.errorImageLabel.setImage(this.getErrorImage());
        this.errorImageLabel.setVisible(false);
        this.errorMessageLabel = new Label(composite, 72);
        this.errorMessageLabel.setLayoutData((Object)new GridData(768));
    }

    void validate() {
        String errorMessage = "";
        for (String predefinedChartSet : this.predefinedChartSets) {
            if (!predefinedChartSet.equals(this.chartSetText.getText())) continue;
            errorMessage = Messages.illiegalChartSetMsg;
            break;
        }
        this.errorImageLabel.setVisible(!errorMessage.isEmpty());
        this.errorMessageLabel.setText(errorMessage);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(!this.chartSetText.getText().isEmpty());
        }
    }

    private Image getErrorImage() {
        if (this.errorImage == null || this.errorImage.isDisposed()) {
            this.errorImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK").createImage();
        }
        return this.errorImage;
    }
}

