/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanAttribute;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Marker;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.swtchart.Chart;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.Range;
import org.swtchart.internal.PlotArea;

public class TimelineChart
extends Chart
implements IPropertyChangeListener {
    private RefreshJob refreshJob;
    private IMonitoredMXBeanGroup attributeGroup;
    private String sectionId;
    private ExpandableComposite section;
    private List<Color> colors;
    Marker marker;

    public TimelineChart(Composite parent, ExpandableComposite section, IMonitoredMXBeanGroup group, int style, String sectionId) {
        super(parent, style);
        this.section = section;
        this.attributeGroup = group;
        this.sectionId = sectionId;
        this.colors = new ArrayList<Color>();
        this.createChart(parent);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.marker = new Marker(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("LegendVisibility".equals(event.getProperty()) && !this.isDisposed()) {
            this.getLegend().setVisible(((Boolean)event.getNewValue()).booleanValue());
            this.redraw();
        }
    }

    public void dispose() {
        if (!this.section.isDisposed()) {
            Composite sectionContainer = this.section.getParent();
            this.section.dispose();
            sectionContainer.layout();
        }
        super.dispose();
        for (Color color : this.colors) {
            color.dispose();
        }
    }

    public IMonitoredMXBeanGroup getAttributeGroup() {
        return this.attributeGroup;
    }

    public void refresh() {
        this.refreshJob = new RefreshJob(NLS.bind((String)Messages.refreshChartJobLabel, (Object)this.attributeGroup.getName()), String.valueOf(this.sectionId) + this.attributeGroup.getName()){

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
            }

            @Override
            protected void refreshUI() {
                TimelineChart.this.refreshChartWidget();
            }
        };
        this.refreshJob.schedule();
    }

    public ExpandableComposite getSection() {
        return this.section;
    }

    private ISeries addMonitoredSeries(IMonitoredMXBeanAttribute attribute) {
        ILineSeries series = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, this.getSeriesId(attribute));
        series.setXDateSeries(new Date[0]);
        series.setYSeries(new double[0]);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        this.setColor(series, attribute.getRGB());
        return series;
    }

    private void setColor(ILineSeries series, int[] rgb) {
        if (rgb != null && !this.hasColor(rgb)) {
            Color color = new Color((Device)Display.getDefault(), rgb[0], rgb[1], rgb[2]);
            series.setLineColor(color);
            this.colors.add(color);
        }
    }

    private boolean hasColor(int[] rgb) {
        for (Color color : this.colors) {
            if (color.getRGB().red != rgb[0] || color.getRGB().green != rgb[1] || color.getRGB().blue != rgb[2]) continue;
            return true;
        }
        return false;
    }

    private void createChart(Composite parent) {
        this.getTitle().setVisible(false);
        this.setBackground(parent.getBackground());
        Color black = Display.getDefault().getSystemColor(2);
        this.getAxisSet().getXAxis(0).getTick().setForeground(black);
        this.getAxisSet().getXAxis(0).getTitle().setVisible(false);
        this.getAxisSet().getYAxis(0).getTick().setForeground(black);
        this.getAxisSet().getYAxis(0).getTick().setTickMarkStepHint(30);
        this.getAxisSet().getYAxis(0).getTitle().setVisible(false);
        this.getLegend().setPosition(1024);
        this.getLegend().setVisible(Activator.getDefault().getPreferenceStore().getBoolean("LegendVisibility"));
        MyMouseListener plotAreaListener = new MyMouseListener((Control)this.getPlotArea());
        this.getPlotArea().addListener(5, (Listener)plotAreaListener);
        this.getPlotArea().addListener(3, (Listener)plotAreaListener);
        this.getPlotArea().addListener(4, (Listener)plotAreaListener);
        MyMouseListener chartListener = new MyMouseListener((Control)this);
        this.addListener(5, chartListener);
        this.addListener(3, chartListener);
        this.addListener(4, chartListener);
    }

    void refreshChartWidget() {
        if (this.isDisposed()) {
            return;
        }
        this.deleteMonitoredSeries();
        for (IMonitoredMXBeanAttribute attribute : this.attributeGroup.getAttributes()) {
            String seriesId = this.getSeriesId(attribute);
            ISeries series = this.getSeriesSet().getSeries(seriesId);
            if (series == null && (series = this.addMonitoredSeries(attribute)) == null) {
                return;
            }
            series.setXDateSeries(attribute.getDates().toArray(new Date[0]));
            series.setYSeries(this.getYSeries(attribute));
            this.setColor((ILineSeries)series, attribute.getRGB());
        }
        IMonitoredMXBeanGroup.AxisUnit axisUnit = this.attributeGroup.getAxisUnit();
        if (axisUnit == IMonitoredMXBeanGroup.AxisUnit.MBytes) {
            this.getAxisSet().getYAxis(0).getTick().setFormat((Format)new DecimalFormat("#####.#M"));
            this.getAxisSet().adjustRange();
        } else if (axisUnit == IMonitoredMXBeanGroup.AxisUnit.Percent) {
            this.getAxisSet().getYAxis(0).getTick().setFormat((Format)new DecimalFormat("###%"));
            this.getAxisSet().getXAxis(0).adjustRange();
            this.getAxisSet().getYAxis(0).setRange(new Range(0.0, (double)(this.getSize().y + 10) / (double)this.getSize().y));
        } else if (axisUnit == IMonitoredMXBeanGroup.AxisUnit.Count) {
            this.getAxisSet().getYAxis(0).getTick().setFormat((Format)NumberFormat.getIntegerInstance());
            this.getAxisSet().adjustRange();
        } else {
            this.getAxisSet().adjustRange();
        }
        this.section.setText(this.attributeGroup.getName());
        this.section.layout();
        this.marker.redraw();
        this.redraw();
    }

    private double[] getYSeries(IMonitoredMXBeanAttribute attribute) {
        List values = attribute.getValues();
        double[] ySeries = new double[values.size()];
        double ratio = 1.0;
        if (this.attributeGroup.getAxisUnit() == IMonitoredMXBeanGroup.AxisUnit.MBytes) {
            ratio = 1.0E-6;
        }
        int i = 0;
        while (i < ySeries.length) {
            Number value = (Number)values.get(i);
            if (value instanceof Integer) {
                ySeries[i] = (double)((Integer)value).intValue() * ratio;
            } else if (value instanceof Long) {
                ySeries[i] = (double)((Long)value).longValue() * ratio;
            } else if (value instanceof Double) {
                ySeries[i] = (Double)value * ratio;
            }
            ++i;
        }
        return ySeries;
    }

    private void deleteMonitoredSeries() {
        ISeriesSet seriesSet = this.getSeriesSet();
        List attributes = this.attributeGroup.getAttributes();
        ISeries[] iSeriesArray = seriesSet.getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            String seriesId = series.getId();
            boolean found = false;
            for (IMonitoredMXBeanAttribute attribute : attributes) {
                if (!series.getId().equals(this.getSeriesId(attribute))) continue;
                found = true;
            }
            if (!found) {
                seriesSet.deleteSeries(seriesId);
            }
            ++n2;
        }
    }

    private String getSeriesId(IMonitoredMXBeanAttribute attribute) {
        String canoticalName = attribute.getObjectName().getCanonicalName();
        if (canoticalName.contains("name=")) {
            String[] elements = canoticalName.split("name=");
            String name = elements[1];
            if (name.contains(",")) {
                name = name.split(",")[0];
            }
            return String.valueOf(name) + " : " + attribute.getAttributeName();
        }
        return attribute.getAttributeName();
    }

    private class MyMouseListener
    implements Listener {
        private Control control;

        public MyMouseListener(Control control) {
            this.control = control;
        }

        public void handleEvent(Event event) {
            int position;
            if (this.control instanceof Chart) {
                position = event.x - TimelineChart.this.getPlotArea().getBounds().x;
            } else if (this.control instanceof PlotArea) {
                position = event.x;
            } else {
                throw new IllegalStateException("unknown object");
            }
            switch (event.type) {
                case 5: {
                    if (TimelineChart.this.marker.isDisposed()) break;
                    TimelineChart.this.marker.setPosition(position);
                    break;
                }
                case 3: {
                    if (event.button != 1) break;
                    TimelineChart.this.marker.setPosition(position);
                    break;
                }
                case 4: {
                    TimelineChart.this.marker.dispose();
                    break;
                }
            }
        }
    }
}

