/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.core.mbean.IMBeanServer;
import com.fusesource.ide.jvmmonitor.core.mbean.IMBeanServerChangeListener;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanAttribute;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.core.mbean.MBeanServerEvent;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.RefreshAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.GarbageCollectorAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.ClearTimelineDataAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.ConfigureChartAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.DeleteChartAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.LoadChartSetAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.NewChartAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.SaveChartSetAsAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.TimelineChart;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public class TimelineSection
extends AbstractJvmPropertySection {
    private List<TimelineChart> charts = new ArrayList<TimelineChart>();
    private ClearTimelineDataAction clearAction = new ClearTimelineDataAction(this);
    private RefreshAction refreshAction = new RefreshAction(this);
    private NewChartAction newChartAction = new NewChartAction(this);
    private LoadChartSetAction loadChartSetAction = new LoadChartSetAction(this);
    private GarbageCollectorAction garbageCollectorAction = new GarbageCollectorAction(this);
    private SaveChartSetAsAction saveChartSetAsAction = new SaveChartSetAsAction(this);
    private Separator separator = new Separator();
    private IMBeanServerChangeListener mBeanServerChangeListener;
    private Composite chartsPage;
    private Composite messagePage;
    private PageBook timelinePageBook;

    @Override
    protected void createControls(Composite parent) {
        this.timelinePageBook = new PageBook(parent, 0);
        this.chartsPage = new Composite((Composite)this.timelinePageBook, 0);
        this.messagePage = this.createMessagePage();
        parent.setBackground(Display.getDefault().getSystemColor(25));
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 15;
        this.chartsPage.setLayout((Layout)layout);
        this.timelinePageBook.showPage((Control)this.chartsPage);
        this.mBeanServerChangeListener = new IMBeanServerChangeListener(){

            public void serverChanged(MBeanServerEvent event) {
                new RefreshJob(Messages.reconstructChartJobLabel, this.toString()){

                    @Override
                    protected void refreshUI() {
                        IActiveJvm jvm = TimelineSection.this.getJvm();
                        if (jvm != null) {
                            TimelineSection.this.reconstructCharts(jvm, false);
                        }
                    }
                }.schedule();
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.fusesource.ide.jvmmonitor.ui.timeline_page_content");
    }

    @Override
    public void jvmModelChanged(JvmModelEvent event) {
        super.jvmModelChanged(event);
        if (event.state == JvmModelEvent.State.JvmConnected && !this.chartsPage.isDisposed()) {
            final IActiveJvm newJvm = (IActiveJvm)event.jvm;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TimelineSection.this.reconstructCharts(newJvm, true);
                }
            });
            newJvm.getMBeanServer().addServerChangeListener(this.mBeanServerChangeListener);
        }
    }

    @Override
    protected void setInput(IWorkbenchPart part, ISelection selection, IActiveJvm newJvm, IActiveJvm oldJvm) {
        IMBeanServer server;
        if (newJvm == null || newJvm.equals(oldJvm)) {
            return;
        }
        this.reconstructCharts(newJvm, false);
        if (oldJvm != null && this.mBeanServerChangeListener != null && (server = oldJvm.getMBeanServer()) != null) {
            server.removeServerChangeListener(this.mBeanServerChangeListener);
        }
        newJvm.getMBeanServer().addServerChangeListener(this.mBeanServerChangeListener);
    }

    public void refresh() {
        this.refreshConnectionIndicator();
        IActiveJvm jvm = this.getJvm();
        if (jvm == null || !jvm.isConnected() || this.suspendRefresh || this.chartsPage.isDisposed()) {
            return;
        }
        for (TimelineChart chart : this.charts) {
            if (chart.isDisposed() || !chart.isVisible()) continue;
            chart.refresh();
        }
    }

    @Override
    protected void addToolBarActions(IToolBarManager manager) {
        manager.insertAfter("defaults", (IContributionItem)this.separator);
        if (manager.find(this.refreshAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.refreshAction);
        }
        if (manager.find(this.clearAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.clearAction);
        }
        if (manager.find(this.newChartAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.newChartAction);
        }
    }

    @Override
    protected void removeToolBarActions(IToolBarManager manager) {
        manager.remove((IContributionItem)this.separator);
        manager.remove(this.refreshAction.getId());
        manager.remove(this.clearAction.getId());
        manager.remove(this.newChartAction.getId());
    }

    @Override
    protected void addLocalMenus(IMenuManager manager) {
        if (manager.find(this.saveChartSetAsAction.getId()) == null) {
            manager.add((IAction)this.saveChartSetAsAction);
        }
        if (manager.find(this.loadChartSetAction.getId()) == null) {
            manager.add((IAction)this.loadChartSetAction);
        }
        manager.add((IContributionItem)this.separator);
    }

    @Override
    protected void removeLocalMenus(IMenuManager manager) {
        manager.remove(this.saveChartSetAsAction.getId());
        manager.remove(this.loadChartSetAction.getId());
        manager.remove((IContributionItem)this.separator);
    }

    @Override
    public void dispose() {
        IMBeanServer server;
        super.dispose();
        IActiveJvm jvm = this.getJvm();
        if (jvm != null && (server = jvm.getMBeanServer()) != null) {
            server.removeServerChangeListener(this.mBeanServerChangeListener);
        }
    }

    protected void clear() {
        IActiveJvm jvm = this.getJvm();
        if (jvm != null) {
            for (IMonitoredMXBeanGroup group : jvm.getMBeanServer().getMonitoredAttributeGroups()) {
                group.clearAttributes();
            }
        }
    }

    private Composite createMessagePage() {
        this.messagePage = new Composite((Composite)this.timelinePageBook, 0);
        this.messagePage.setLayout((Layout)new GridLayout(3, false));
        this.messagePage.setBackground(Display.getDefault().getSystemColor(25));
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        Hyperlink hyperlink = toolkit.createHyperlink(this.messagePage, Messages.loadDefaultChartSetLabel, 0);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                try {
                    new LoadChartSetAction(TimelineSection.this).loadDefaultChartSet();
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.loadChartSetFailedMsg, (CoreException)((Object)e));
                }
            }
        });
        return this.messagePage;
    }

    private void refreshConnectionIndicator() {
        IActiveJvm jvm = this.getJvm();
        boolean isConnected = jvm != null && jvm.isConnected();
        this.refreshBackground((Control)this.chartsPage, isConnected);
        for (TimelineChart chart : this.charts) {
            this.refreshBackground((Control)chart, isConnected);
            this.refreshBackground((Control)chart.getPlotArea(), isConnected);
            this.refreshBackground((Control)chart.getSection(), isConnected);
        }
        this.refreshBackground((Control)this.messagePage, isConnected);
        this.clearAction.setEnabled(isConnected);
        this.refreshAction.setEnabled(isConnected);
        this.newChartAction.setEnabled(isConnected);
        this.loadChartSetAction.setEnabled(isConnected);
        this.garbageCollectorAction.setEnabled(isConnected);
    }

    void reconstructCharts(IActiveJvm activeJvm, boolean connected) {
        List groups;
        if (this.chartsPage.isDisposed()) {
            return;
        }
        if (connected) {
            try {
                this.loadChartSetAction.loadDefaultChartSet();
            }
            catch (JvmCoreException e) {
                Activator.log(Messages.configureMonitoredAttributesFailedMsg, (CoreException)((Object)e));
            }
        }
        if ((groups = activeJvm.getMBeanServer().getMonitoredAttributeGroups()).size() == 0) {
            this.timelinePageBook.showPage((Control)this.messagePage);
            return;
        }
        this.timelinePageBook.showPage((Control)this.chartsPage);
        this.chartsPage.setVisible(false);
        for (TimelineChart chart : this.charts) {
            chart.dispose();
        }
        this.charts.clear();
        GridLayout layout = (GridLayout)this.chartsPage.getLayout();
        layout.numColumns = groups.size() > 1 ? 2 : 1;
        this.chartsPage.setLayout((Layout)layout);
        for (IMonitoredMXBeanGroup group : groups) {
            this.createSection(this.chartsPage, group);
        }
        this.chartsPage.layout();
        this.chartsPage.setVisible(true);
        this.refresh();
    }

    private void createSection(Composite parent, IMonitoredMXBeanGroup group) {
        if (parent.isDisposed()) {
            return;
        }
        Section section = this.getWidgetFactory().createSection(parent, 256);
        section.setText(group.getName());
        section.setLayoutData((Object)new GridData(1808));
        Composite flatFormComposite = this.getWidgetFactory().createFlatFormComposite((Composite)section);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        flatFormComposite.setLayout((Layout)formLayout);
        TimelineChart chart = new TimelineChart(flatFormComposite, (ExpandableComposite)section, group, 0, String.valueOf(((Object)((Object)this)).toString()) + this.getJvm().getPid());
        this.charts.add(chart);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        chart.setLayoutData(data);
        section.setClient((Control)flatFormComposite);
        ArrayList<Action> actions = new ArrayList<Action>();
        for (IMonitoredMXBeanAttribute attribute : group.getAttributes()) {
            if (!attribute.getAttributeName().startsWith("HeapMemoryUsage")) continue;
            actions.add(this.garbageCollectorAction);
            break;
        }
        actions.add(new ConfigureChartAction(chart, this));
        actions.add(new DeleteChartAction(chart, this));
        this.addSectionActions((ExpandableComposite)section, actions);
    }

    private void addSectionActions(ExpandableComposite expandableComposite, List<Action> actions) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)expandableComposite);
        final Cursor cursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(cursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!cursor.isDisposed()) {
                    cursor.dispose();
                }
            }
        });
        for (Action action : actions) {
            toolBarManager.add((IAction)action);
        }
        toolBarManager.update(true);
        expandableComposite.setTextClient((Control)toolbar);
    }
}

