/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.views;

import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.ISnapshot;
import com.fusesource.ide.jvmmonitor.core.ITerminatedJvm;
import com.fusesource.ide.jvmmonitor.core.JvmModel;
import com.fusesource.ide.jvmmonitor.internal.ui.views.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class DeleteAction
extends Action
implements ISelectionChangedListener {
    private List<ITerminatedJvm> jvms;
    private List<IHost> remoteHosts;
    private List<ISnapshot> snapshots;
    private TreeViewer treeViewer;
    private Object firstElement;

    public DeleteAction(TreeViewer treeViewer, IActionBars actionBars) {
        this.treeViewer = treeViewer;
        this.jvms = new ArrayList<ITerminatedJvm>();
        this.remoteHosts = new ArrayList<IHost>();
        this.snapshots = new ArrayList<ISnapshot>();
        this.setText(Messages.deleteLabel);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof TreeSelection)) {
            return;
        }
        this.jvms.clear();
        this.remoteHosts.clear();
        this.snapshots.clear();
        this.firstElement = ((TreeSelection)event.getSelection()).getFirstElement();
        Object[] objectArray = ((TreeSelection)event.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ITerminatedJvm) {
                this.jvms.add((ITerminatedJvm)element);
            } else if (element instanceof ISnapshot) {
                this.snapshots.add((ISnapshot)element);
            } else if (element instanceof IHost) {
                if (!((IHost)element).isLocalHost()) {
                    this.remoteHosts.add((IHost)element);
                }
            } else {
                this.jvms.clear();
                this.remoteHosts.clear();
                this.snapshots.clear();
                break;
            }
            ++n2;
        }
        this.setEnabled(this.jvms.size() > 0 || this.snapshots.size() > 0 || this.remoteHosts.size() > 0);
    }

    public void run() {
        if (!this.confirm()) {
            return;
        }
        this.deleteJvms();
        for (IHost host : this.remoteHosts) {
            this.jvms = host.getTerminatedJvms();
            this.deleteJvms();
        }
        for (IHost host : this.remoteHosts) {
            JvmModel.getInstance().removeHost(host);
        }
        for (ISnapshot snapshot : this.snapshots) {
            this.closeEditor(snapshot.getFileStore());
            snapshot.getJvm().deleteSnapshot(snapshot);
        }
        this.treeViewer.refresh();
    }

    private boolean confirm() {
        String elementName;
        int size = this.jvms.size() + this.remoteHosts.size() + this.snapshots.size();
        String message = size == 1 ? ((elementName = this.firstElement.toString()).isEmpty() ? Messages.confirmDeleteSelectedElementMsg : NLS.bind((String)Messages.confirmDeleteElementMsg, (Object)elementName)) : NLS.bind((String)Messages.confirmDeleteElementsMsg, (Object)String.valueOf(size));
        return MessageDialog.openConfirm((Shell)this.treeViewer.getControl().getShell(), (String)Messages.confirmDeleteTitle, (String)message);
    }

    private void deleteJvms() {
        for (ITerminatedJvm jvm : this.jvms) {
            for (ISnapshot snapshot : jvm.getShapshots()) {
                this.closeEditor(snapshot.getFileStore());
            }
            jvm.getHost().removeJvm(jvm.getPid());
        }
    }

    private void closeEditor(final IFileStore fileStore) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = page.findEditor((IEditorInput)input);
                if (editor != null) {
                    page.closeEditor(editor, false);
                }
            }
        });
    }
}

