/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.views;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.IJvm;
import com.fusesource.ide.jvmmonitor.core.ISnapshot;
import com.fusesource.ide.jvmmonitor.core.ITerminatedJvm;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import com.fusesource.ide.jvmmonitor.ui.ISharedImages;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class JvmTreeLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ISharedImages {
    private Image localHostImage;
    private Image remoteHostImage;
    private Image connectedJvmImage;
    private Image disconnectedJvmImage;
    private Image terminatedJvmImage;
    private Image threadDumpImage;
    private Image hprofDumpImage;
    private Image heapDumpImage;
    private Image cpuDumpImage;

    public Image getImage(Object element) {
        if (element instanceof IHost) {
            if ("localhost".equals(((IHost)element).getName())) {
                return this.getLocalHostImage();
            }
            return this.getRemoteHostImage();
        }
        if (element instanceof IActiveJvm) {
            if (((IActiveJvm)element).isConnected()) {
                return this.getConnectedJvmImage();
            }
            return this.getDisconnectedJvmImage();
        }
        if (element instanceof IJvm) {
            return this.getTerminatedJvmImage();
        }
        if (element instanceof ISnapshot) {
            if (((ISnapshot)element).getType() == ISnapshot.SnapshotType.Thread) {
                return this.getThreadDumpImage();
            }
            if (((ISnapshot)element).getType() == ISnapshot.SnapshotType.Hprof) {
                return this.getHprofDumpImage();
            }
            if (((ISnapshot)element).getType() == ISnapshot.SnapshotType.Heap) {
                return this.getHeapDumpImage();
            }
            if (((ISnapshot)element).getType() == ISnapshot.SnapshotType.Cpu) {
                return this.getCpuDumpImage();
            }
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        StyledString text = new StyledString();
        if (element instanceof IJvm) {
            String prefix = "";
            String mainClass = ((IJvm)element).getMainClass();
            String suffix = this.getIdInicator((IJvm)element);
            if (element instanceof ITerminatedJvm) {
                prefix = "<terminated>";
            }
            text.append(prefix).append(mainClass).append(suffix);
            text.setStyle(prefix.length() + mainClass.length(), suffix.length(), StyledString.DECORATIONS_STYLER);
        } else if (element instanceof ISnapshot) {
            String fileName = ((ISnapshot)element).getFileStore().getName();
            text.append(fileName);
            String date = ((ISnapshot)element).getTimeStamp();
            if (date != null) {
                text.append(" (").append(date).append(")");
            }
        } else {
            text.append(element.toString());
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.localHostImage != null) {
            this.localHostImage.dispose();
        }
        if (this.remoteHostImage != null) {
            this.remoteHostImage.dispose();
        }
        if (this.connectedJvmImage != null) {
            this.connectedJvmImage.dispose();
        }
        if (this.disconnectedJvmImage != null) {
            this.disconnectedJvmImage.dispose();
        }
        if (this.terminatedJvmImage != null) {
            this.terminatedJvmImage.dispose();
        }
        if (this.threadDumpImage != null) {
            this.threadDumpImage.dispose();
        }
        if (this.heapDumpImage != null) {
            this.heapDumpImage.dispose();
        }
        if (this.hprofDumpImage != null) {
            this.hprofDumpImage.dispose();
        }
        if (this.cpuDumpImage != null) {
            this.cpuDumpImage.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private Image getLocalHostImage() {
        if (this.localHostImage == null || this.localHostImage.isDisposed()) {
            this.localHostImage = Activator.getImageDescriptor("icons/full/obj16/local_host_obj.png").createImage();
        }
        return this.localHostImage;
    }

    private Image getRemoteHostImage() {
        if (this.remoteHostImage == null || this.remoteHostImage.isDisposed()) {
            this.remoteHostImage = Activator.getImageDescriptor("icons/full/obj16/remote_host_obj.png").createImage();
        }
        return this.remoteHostImage;
    }

    private Image getConnectedJvmImage() {
        if (this.connectedJvmImage == null || this.connectedJvmImage.isDisposed()) {
            this.connectedJvmImage = Activator.getImageDescriptor("icons/full/obj16/connected_jvm_obj.png").createImage();
        }
        return this.connectedJvmImage;
    }

    private Image getDisconnectedJvmImage() {
        if (this.disconnectedJvmImage == null || this.disconnectedJvmImage.isDisposed()) {
            this.disconnectedJvmImage = Activator.getImageDescriptor("icons/full/obj16/disconnected_jvm_obj.png").createImage();
        }
        return this.disconnectedJvmImage;
    }

    private Image getTerminatedJvmImage() {
        if (this.terminatedJvmImage == null || this.terminatedJvmImage.isDisposed()) {
            this.terminatedJvmImage = Activator.getImageDescriptor("icons/full/obj16/terminated_jvm_obj.gif").createImage();
        }
        return this.terminatedJvmImage;
    }

    private Image getThreadDumpImage() {
        if (this.threadDumpImage == null || this.threadDumpImage.isDisposed()) {
            this.threadDumpImage = Activator.getImageDescriptor("icons/full/obj16/thread_dump.gif").createImage();
        }
        return this.threadDumpImage;
    }

    private Image getHprofDumpImage() {
        if (this.hprofDumpImage == null || this.hprofDumpImage.isDisposed()) {
            this.hprofDumpImage = Activator.getImageDescriptor("icons/full/obj16/hprof_dump.gif").createImage();
        }
        return this.hprofDumpImage;
    }

    private Image getHeapDumpImage() {
        if (this.heapDumpImage == null || this.heapDumpImage.isDisposed()) {
            this.heapDumpImage = Activator.getImageDescriptor("icons/full/obj16/heap_dump.gif").createImage();
        }
        return this.heapDumpImage;
    }

    private Image getCpuDumpImage() {
        if (this.cpuDumpImage == null || this.cpuDumpImage.isDisposed()) {
            this.cpuDumpImage = Activator.getImageDescriptor("icons/full/obj16/cpu_dump.gif").createImage();
        }
        return this.cpuDumpImage;
    }

    private String getIdInicator(IJvm jvm) {
        int pid = jvm.getPid();
        int port = jvm.getPort();
        StringBuffer buffer = new StringBuffer();
        if (pid != -1) {
            buffer.append(" [PID: ").append(pid).append("]");
        }
        if (port != -1) {
            buffer.append(" [Port: ").append(port).append("]");
        }
        return buffer.toString();
    }
}

