/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.views;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.IJvmModelChangeListener;
import com.fusesource.ide.jvmmonitor.core.ISnapshot;
import com.fusesource.ide.jvmmonitor.core.JvmModel;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import com.fusesource.ide.jvmmonitor.internal.ui.views.DeleteAction;
import com.fusesource.ide.jvmmonitor.internal.ui.views.JvmTreeContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.views.JvmTreeLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.views.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.views.OpenSnapshotAction;
import com.fusesource.ide.jvmmonitor.internal.ui.views.RenameAction;
import com.fusesource.ide.jvmmonitor.internal.ui.views.StartMonitoringAction;
import com.fusesource.ide.jvmmonitor.internal.ui.views.StopMonitoringAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;

public class JvmTreeViewer
extends TreeViewer
implements IJvmModelChangeListener,
ISelectionChangedListener,
IDoubleClickListener {
    private StartMonitoringAction startMonitoringAction;
    private StopMonitoringAction stopMonitoringAction;
    private OpenSnapshotAction openSnapshotAction;
    private DeleteAction deleteAction;
    private CopyAction copyAction;
    private RenameAction renameAction;
    Image errorImage;
    IStatusLineManager statusLineManager;
    StatusLineContributionItem statusLineItem;

    public JvmTreeViewer(Composite parent, int style, IActionBars actionBars) {
        super(parent, style);
        this.statusLineManager = actionBars.getStatusLineManager();
        this.statusLineItem = new StatusLineContributionItem("StatusLineContributionItem");
        this.statusLineManager.add((IContributionItem)this.statusLineItem);
        this.setContentProvider((IContentProvider)new JvmTreeContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new JvmTreeLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        this.createContextMenu(actionBars);
        this.addListeners();
        new Job(Messages.initializeJvmExplorer){

            protected IStatus run(IProgressMonitor monitor) {
                JvmModel.getInstance();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JvmTreeViewer.this.setInput(new Object[0]);
                        JvmModel.getInstance().addJvmModelChangeListener((IJvmModelChangeListener)JvmTreeViewer.this);
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void jvmModelChanged(final JvmModelEvent e) {
        if (e.state == JvmModelEvent.State.CpuProfilerConfigChanged) {
            return;
        }
        if (e.state == JvmModelEvent.State.JvmConnected || e.state == JvmModelEvent.State.JvmDisconnected) {
            this.startMonitoringAction.refresh();
            this.stopMonitoringAction.refresh();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (JvmTreeViewer.this.getControl().isDisposed()) {
                    return;
                }
                if (e.state == JvmModelEvent.State.JvmDisconnected) {
                    JvmTreeViewer.this.updateSelection((ISelection)new StructuredSelection());
                    return;
                }
                if (e.state == JvmModelEvent.State.ShapshotTaken && e.source instanceof ISnapshot) {
                    JvmTreeViewer.this.refresh();
                    JvmTreeViewer.this.setSelection((ISelection)new StructuredSelection(e.source));
                    return;
                }
                if (e.state == JvmModelEvent.State.JvmAdded) {
                    IHost host = e.jvm.getHost();
                    JvmTreeViewer.this.setExpandedState(host, true);
                }
                if (JvmTreeViewer.this.getControl().isFocusControl()) {
                    JvmTreeViewer.this.updateStatusLine((IStructuredSelection)JvmTreeViewer.this.getSelection());
                }
                JvmTreeViewer.this.refresh();
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateStatusLine((IStructuredSelection)event.getSelection());
    }

    public void doubleClick(DoubleClickEvent event) {
        this.startMonitoringAction.run();
        if (this.openSnapshotAction.isEnabled()) {
            this.openSnapshotAction.run();
        }
    }

    public void updateSelection(ISelection selection) {
        super.updateSelection(selection);
    }

    protected void dispose() {
        JvmModel.getInstance().removeJvmModelChangeListener((IJvmModelChangeListener)this);
        this.removeSelectionChangedListener(this);
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
    }

    private void addListeners() {
        this.addDoubleClickListener(this);
        this.addSelectionChangedListener(this);
        this.addSelectionChangedListener(this.startMonitoringAction);
        this.addSelectionChangedListener(this.stopMonitoringAction);
        this.addSelectionChangedListener(this.openSnapshotAction);
        this.addSelectionChangedListener(this.copyAction);
        this.addSelectionChangedListener(this.deleteAction);
        this.addSelectionChangedListener(this.renameAction);
    }

    private void createContextMenu(IActionBars actionBars) {
        this.startMonitoringAction = new StartMonitoringAction();
        this.stopMonitoringAction = new StopMonitoringAction(this);
        this.openSnapshotAction = new OpenSnapshotAction();
        this.copyAction = CopyAction.createCopyAction(actionBars);
        this.deleteAction = new DeleteAction(this, actionBars);
        this.renameAction = new RenameAction(this, actionBars);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JvmTreeViewer.this.configureMenus(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    void configureMenus(IMenuManager manager) {
        if (this.startMonitoringAction.getVisible()) {
            manager.add((IAction)this.startMonitoringAction);
        }
        if (this.stopMonitoringAction.getVisible()) {
            manager.add((IAction)this.stopMonitoringAction);
            manager.add((IContributionItem)new Separator());
        }
        if (this.openSnapshotAction.getVisible()) {
            manager.add((IAction)this.openSnapshotAction);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IAction)this.renameAction);
    }

    void updateStatusLine(final IStructuredSelection selection) {
        RefreshJob refreshJob = new RefreshJob(Messages.refreshStatusLineJobLabel, JvmTreeViewer.class.getName()){
            private ICpuProfiler.ProfilerState state;
            private Object element;

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                this.element = selection.getFirstElement();
                if (this.element instanceof IActiveJvm) {
                    IActiveJvm activeJvm = (IActiveJvm)this.element;
                    this.state = activeJvm.getCpuProfiler().getState();
                }
            }

            @Override
            protected void refreshUI() {
                IHost host;
                StringBuffer text = new StringBuffer();
                StringBuffer errorText = new StringBuffer();
                JvmTreeViewer.this.errorImage = null;
                if (this.element instanceof IActiveJvm) {
                    IActiveJvm activeJvm = (IActiveJvm)this.element;
                    if (activeJvm.isConnected()) {
                        text.append(Messages.connectedMsg);
                        if (this.state == ICpuProfiler.ProfilerState.RUNNING) {
                            text.append(" ").append(Messages.cpuProfilerRunningMsg);
                        }
                    } else if (!activeJvm.isConnectionSupported()) {
                        String errorMessage = activeJvm.getErrorStateMessage();
                        if (errorMessage != null) {
                            errorText.append(errorMessage);
                        }
                    } else {
                        text.append(Messages.disconnectedMsg);
                    }
                } else if (this.element instanceof IHost && (host = (IHost)this.element).getName().equals("localhost") && !JvmModel.getInstance().hasValidJdk()) {
                    errorText.append(Messages.invalidJdkLocationMsg);
                    JvmTreeViewer.this.errorImage = JvmTreeViewer.this.getErrorImage();
                }
                JvmTreeViewer.this.statusLineManager.setErrorMessage(JvmTreeViewer.this.errorImage, errorText.toString());
                JvmTreeViewer.this.statusLineItem.setText(text.toString());
            }
        };
        refreshJob.schedule();
    }

    Image getErrorImage() {
        if (this.errorImage == null || this.errorImage.isDisposed()) {
            this.errorImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK").createImage();
        }
        return this.errorImage;
    }
}

