/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.views;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.views.JvmExplorer;
import com.fusesource.ide.jvmmonitor.internal.ui.views.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertyShowInContext;

public class StartMonitoringAction
extends Action
implements ISelectionChangedListener {
    List<IActiveJvm> jvms = new ArrayList<IActiveJvm>();
    private boolean visible = false;

    public StartMonitoringAction() {
        this.setText(Messages.startMonitoringLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/connect.png"));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof TreeSelection)) {
            return;
        }
        this.jvms.clear();
        this.visible = false;
        Object[] objectArray = ((TreeSelection)event.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!(element instanceof IActiveJvm)) {
                this.visible = false;
                this.jvms.clear();
                break;
            }
            this.jvms.add((IActiveJvm)element);
            this.visible = true;
            ++n2;
        }
        this.refresh();
    }

    public void run() {
        new Job(Messages.startMonitoringJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                for (final IActiveJvm jvm : StartMonitoringAction.this.jvms) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            StartMonitoringAction.this.showPropertiesView(jvm);
                        }
                    });
                    if (jvm.isConnected() || !StartMonitoringAction.this.isEnabled()) continue;
                    try {
                        int period = Activator.getDefault().getPreferenceStore().getInt("UpdatePeriod");
                        jvm.connect(period);
                    }
                    catch (JvmCoreException e) {
                        Activator.log(NLS.bind((String)Messages.connectJvmFailedMsg, (Object)jvm.getPid()), (CoreException)((Object)e));
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void refresh() {
        boolean enable = true;
        for (IActiveJvm jvm : this.jvms) {
            if (!jvm.isConnected() && jvm.isConnectionSupported()) continue;
            enable = false;
        }
        this.setEnabled(enable);
    }

    public void showPropertiesView(IActiveJvm jvm) {
        try {
            List<PropertySheet> views = this.getProperriesView();
            if (views.size() == 0) {
                this.openPropertiesView(jvm);
                return;
            }
            PropertySheet view = this.getPropertiesView(jvm, views);
            if (view != null) {
                this.brindPropertiesViewToFront(view);
                return;
            }
            view = this.getNonPinnedPropertiesView(views);
            if (view != null) {
                this.brindPropertiesViewToFront(view);
                return;
            }
            this.openPropertiesView(jvm);
        }
        catch (PartInitException e) {
            Activator.log(4, Messages.bringPropertiesViewToFrontFailedMsg, e);
        }
    }

    protected boolean getVisible() {
        return this.visible;
    }

    private List<PropertySheet> getProperriesView() {
        IViewReference[] views;
        ArrayList<PropertySheet> list = new ArrayList<PropertySheet>();
        IViewReference[] iViewReferenceArray = views = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            if ("org.eclipse.ui.views.PropertySheet".equals(viewReference.getId())) {
                list.add((PropertySheet)viewReference.getView(true));
            }
            ++n2;
        }
        return list;
    }

    private PropertySheet getPropertiesView(IActiveJvm jvm, List<PropertySheet> views) {
        for (PropertySheet view : views) {
            Object element;
            ISelection selection = view.getShowInContext().getSelection();
            if (!(selection instanceof TreeSelection) || !jvm.equals(element = ((TreeSelection)selection).getFirstElement())) continue;
            return view;
        }
        return null;
    }

    private PropertySheet getNonPinnedPropertiesView(List<PropertySheet> views) {
        for (PropertySheet view : views) {
            if (view.isPinned()) continue;
            return view;
        }
        return null;
    }

    private void openPropertiesView(IActiveJvm jvm) throws PartInitException {
        PropertySheet view = (PropertySheet)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet", String.valueOf(new Date().getTime()), 1);
        PropertyShowInContext context = (PropertyShowInContext)view.getShowInContext();
        if (context.getSelection() == null) {
            JvmExplorer jvmExplorer = (JvmExplorer)context.getPart();
            view.selectionChanged((IWorkbenchPart)jvmExplorer, jvmExplorer.getSelection());
        }
    }

    private void brindPropertiesViewToFront(PropertySheet view) throws PartInitException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)view);
        view.setPinned(true);
    }
}

