/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.core.internal;

import com.fusesource.rider.commons.logging.RiderLogFacade;
import com.fusesource.rider.preferences.PreferenceManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Activator
extends Plugin {
    protected static Activator instance;
    private static IViewPart part;
    public static final String TERMINAL_VIEW_ID = "com.fusesource.rider.server.karaf.view.TerminalView";
    public static final String PLUGIN_ID = "com.fusesource.rider.server.karaf.core";
    public static final String KARAF_21 = "com.fusesource.rider.server.karaf.21";
    public static final String KARAF_22 = "com.fusesource.rider.server.karaf.22";

    public Activator() {
        instance = this;
    }

    public static Activator getDefault() {
        return instance;
    }

    public static String getPreference(String id) {
        return PreferenceManager.getInstance().loadPreferenceAsString(id);
    }

    public static void setPreference(String id, String value) {
        PreferenceManager.getInstance().savePreference(id, value);
    }

    public static IViewPart openTerminalView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (activeWindow = wb.getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null) {
                    try {
                        part = activePage.showView(Activator.TERMINAL_VIEW_ID);
                    }
                    catch (CoreException ex) {
                        Activator.getLogger().error("Unable to create the terminal view!", (Throwable)ex);
                    }
                }
            }
        });
        return part;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)Activator.getDefault().getLog());
    }
}

