/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.core.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FuseESBUtils {
    public static boolean isValidFuseESBInstallation(File path, String version) {
        File[] folders;
        boolean valid = false;
        if (path != null && path.isDirectory() && (folders = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File checkFile) {
                return checkFile.isDirectory() && (checkFile.getName().equalsIgnoreCase("bin") || checkFile.getName().equalsIgnoreCase("etc") || checkFile.getName().equalsIgnoreCase("deploy") || checkFile.getName().equalsIgnoreCase("system"));
            }
        })).length == 4) {
            valid = FuseESBUtils.checkVersion(path, version);
        }
        return valid;
    }

    public static String getVersion(File installFolder) {
        Attributes am;
        String version = null;
        String jarPath = String.format("%s%slib%sesb-version.jar", installFolder.getPath(), File.separator, File.separator);
        File f = new File(jarPath);
        JarFile jar = null;
        if (f.exists() && f.isFile()) {
            try {
                jar = new JarFile(f);
            }
            catch (IOException iOException) {
                jar = null;
            }
        }
        Manifest mf = null;
        if (jar != null) {
            try {
                mf = jar.getManifest();
            }
            catch (IOException iOException) {
                mf = null;
            }
        }
        if (mf != null && (am = mf.getMainAttributes()) != null) {
            version = am.getValue("Bundle-Version");
        }
        return version;
    }

    public static boolean checkVersion(File installFolder, String version) {
        boolean match = false;
        if (version != null) {
            String checkVersion = version.trim().endsWith(".") ? version : String.valueOf(version) + ".";
            String jarVersion = FuseESBUtils.getVersion(installFolder);
            if (jarVersion != null && jarVersion.trim().startsWith(checkVersion)) {
                match = true;
            }
        } else {
            match = true;
        }
        return match;
    }
}

