/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.core.internal;

import com.fusesource.rider.server.karaf.core.internal.Activator;
import com.fusesource.rider.server.karaf.core.internal.Messages;
import com.fusesource.rider.server.karaf.core.internal.server.KarafServerBehaviourDelegate;
import com.fusesource.rider.server.karaf.view.ITerminalConnectionListener;
import com.fusesource.rider.server.karaf.view.SshView;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.server.core.IServer;

public class SshConnector
implements ITerminalConnectionListener {
    private int port;
    private String host;
    private String userName;
    private String passwd;
    private IServer server;
    private KarafServerBehaviourDelegate behaviorDelegate;
    private static final String TERMINAL_VIEW_LABEL = Messages.shellViewLabel;

    public SshConnector(IServer server, KarafServerBehaviourDelegate behaviorDelegate, String host, int port, String user, String pass) {
        this.server = server;
        this.behaviorDelegate = behaviorDelegate;
        this.host = host;
        this.port = port;
        this.userName = user;
        this.passwd = pass;
    }

    public void start() {
        IViewPart vp = Activator.openTerminalView();
        if (vp == null || !(vp instanceof SshView)) {
            Activator.getLogger().error("Unable to open the terminal view!");
            return;
        }
        SshView connectorView = (SshView)vp;
        connectorView.setPartName(this.server.getName());
        connectorView.addConnectionListener((ITerminalConnectionListener)this);
        try {
            connectorView.createConnectionIfNotExists(this.host, this.port, this.userName, this.passwd);
        }
        catch (Exception ex) {
            Activator.getLogger().error("Unable to connect via SSH", (Throwable)ex);
        }
    }

    public void onConnect() {
        this.behaviorDelegate.setLaunched();
        Activator.openTerminalView().setFocus();
    }

    public void onDisconnect() {
        this.behaviorDelegate.stop(false);
        IViewPart vp = Activator.openTerminalView();
        if (vp == null || !(vp instanceof SshView)) {
            Activator.getLogger().error("Unable to open the terminal view!");
            return;
        }
        SshView connectorView = (SshView)vp;
        connectorView.removeConnectionListener((ITerminalConnectionListener)this);
        connectorView.setPartName(TERMINAL_VIEW_LABEL);
    }
}

