/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.core.internal.launch;

import com.fusesource.rider.server.karaf.core.internal.SshConnector;
import com.fusesource.rider.server.karaf.core.internal.server.KarafServerBehaviourDelegate;
import com.fusesource.rider.server.karaf.core.internal.server.KarafServerDelegate;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class KarafLaunchDelegate
implements ILaunchConfigurationDelegate {
    private static final String QUOTE = "\"";
    private static final String EMPTY_STRING = "";
    public static final String ATTR_SERVER_ID = "server-id";
    private SshConnector connector;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String serverId = configuration.getAttribute(ATTR_SERVER_ID, null);
        IServer server = ServerCore.findServer((String)serverId);
        server.getHost();
        KarafServerBehaviourDelegate behaviorDelegate = (KarafServerBehaviourDelegate)((Object)server.loadAdapter(KarafServerBehaviourDelegate.class, null));
        monitor.beginTask("Starting Server...", 10);
        behaviorDelegate.setupLaunch(mode);
        IProcess prs = this.launchUsingJavaLaunchConfig(behaviorDelegate, configuration, mode, launch, monitor);
        behaviorDelegate.setKarafProcess(prs, monitor);
        monitor.done();
        KarafServerDelegate serverDelegate = (KarafServerDelegate)server.getAdapter(KarafServerDelegate.class);
        String host = serverDelegate.getHostName() != null ? serverDelegate.getHostName() : "localhost";
        int port = serverDelegate.getPortNumber();
        String user = null;
        String pass = null;
        if (serverDelegate.getServer().getServerType().getId().indexOf("com.fusesource.rider.server.smx.") != -1) {
            user = serverDelegate.getUserName() != null ? serverDelegate.getUserName() : "smx";
            pass = serverDelegate.getPassword() != null ? serverDelegate.getPassword() : "smx";
        } else if (serverDelegate.getServer().getServerType().getId().indexOf("com.fusesource.rider.server.karaf.") != -1) {
            user = serverDelegate.getUserName() != null ? serverDelegate.getUserName() : "karaf";
            pass = serverDelegate.getPassword() != null ? serverDelegate.getPassword() : "karaf";
        } else if (serverDelegate.getServer().getServerType().getId().indexOf("com.fusesource.rider.server.fuseesb.") != -1) {
            user = serverDelegate.getUserName() != null ? serverDelegate.getUserName() : "smx";
            pass = serverDelegate.getPassword() != null ? serverDelegate.getPassword() : "smx";
        } else {
            user = serverDelegate.getUserName() != null ? serverDelegate.getUserName() : EMPTY_STRING;
            pass = serverDelegate.getPassword() != null ? serverDelegate.getPassword() : EMPTY_STRING;
        }
        this.connector = new SshConnector(server, behaviorDelegate, host, port, user, pass);
        this.connector.start();
    }

    private IProcess launchUsingJavaCommand(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        List classPath = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, Collections.EMPTY_LIST);
        StringBuffer classPathBuffer = new StringBuffer(" -classpath \"");
        for (Object classPathEntry : classPath) {
            IRuntimeClasspathEntry entry = JavaRuntime.newRuntimeClasspathEntry((String)classPathEntry.toString());
            classPathBuffer.append(String.valueOf(entry.getPath().toOSString()) + File.pathSeparator);
        }
        classPathBuffer.append("\" ");
        String vmArgs = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, EMPTY_STRING);
        String launchProgram = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
        String workingDir = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, EMPTY_STRING);
        File workDirFile = new File(workingDir);
        String javaCommandPath = "java ";
        IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        if (defaultVMInstall != null) {
            String javaPath = defaultVMInstall.getInstallLocation().getAbsolutePath();
            javaCommandPath = QUOTE + javaPath + File.separator + "bin" + File.separator + "java" + QUOTE;
        }
        String launchCommand = String.valueOf(javaCommandPath) + classPathBuffer.toString() + vmArgs + " " + launchProgram;
        try {
            Process karafProcess = Runtime.getRuntime().exec(launchCommand, null, workDirFile);
            IProcess prs = DebugPlugin.newProcess((ILaunch)launch, (Process)karafProcess, (String)"Karaf", (Map)Collections.EMPTY_MAP);
            return prs;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IProcess launchUsingJavaLaunchConfig(KarafServerBehaviourDelegate behaviorDelegate, ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationType type;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        if (manager != null && (type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION)) != null) {
            IProcess[] processes;
            String serverId = configuration.getAttribute(ATTR_SERVER_ID, EMPTY_STRING);
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, serverId);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, Collections.EMPTY_LIST));
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, EMPTY_STRING));
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING));
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true));
            HashMap<String, String> vmMap = new HashMap<String, String>(4);
            vmMap.put(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, "java");
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, vmMap);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, EMPTY_STRING));
            ILaunch launch2 = workingCopy.launch(mode, monitor);
            if (launch2 != null && (processes = launch2.getProcesses()) != null && processes.length > 0) {
                launch.addProcess(processes[0]);
                return processes[0];
            }
        }
        return null;
    }
}

