/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.core.internal.runtime;

import com.fusesource.rider.server.karaf.core.internal.KarafUtils;
import com.fusesource.rider.server.karaf.core.internal.runtime.IKarafRuntime;
import com.fusesource.rider.server.karaf.core.internal.runtime.IKarafRuntimeWorkingCopy;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public class KarafRuntimeLocator
extends RuntimeLocatorDelegate {
    protected static final int MAX_RECURSION_DEPTH = 5;
    protected static HashMap<String, IRuntimeWorkingCopy> foundRuntimes = new HashMap();
    protected static int recursionLevel;

    public void searchForRuntimes(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        KarafRuntimeLocator.reset();
        if (path == null) {
            monitor.done();
            return;
        }
        File f = new File(path.toOSString());
        if (f.isDirectory()) {
            monitor.beginTask("Searching for Apache Karaf in " + f.getPath() + "...", -1);
            KarafRuntimeLocator.search(f, listener, monitor);
            monitor.worked(1);
        }
        monitor.done();
        KarafRuntimeLocator.reset();
    }

    private static void reset() {
        recursionLevel = 0;
        foundRuntimes.clear();
    }

    public static void search(File folder, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (recursionLevel == 5) {
            return;
        }
        ++recursionLevel;
        File[] files = null;
        files = folder == null ? File.listRoots() : folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.isFile() && pathname.getName().equalsIgnoreCase("karaf.jar");
            }
        });
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                File[] folders;
                if (f.getParentFile().getName().equalsIgnoreCase("lib") && (folders = f.getParentFile().getParentFile().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File checkFile) {
                        return checkFile.isDirectory() && (checkFile.getName().equalsIgnoreCase("bin") || checkFile.getName().equalsIgnoreCase("system"));
                    }
                })).length == 2 && !foundRuntimes.containsKey(f.getPath()) && KarafRuntimeLocator.checkRuntime(f, listener, monitor)) {
                    --recursionLevel;
                    return;
                }
            } else if (f.isDirectory()) {
                monitor.beginTask("Searching for Apache Karaf in " + f.getPath() + "...", -1);
                KarafRuntimeLocator.search(f, listener, monitor);
                monitor.worked(1);
            }
            ++n2;
        }
        --recursionLevel;
    }

    private static boolean checkRuntime(File karafJar, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        boolean valid = false;
        File baseFolder = karafJar.getParentFile().getParentFile();
        monitor.beginTask("Examine possible Apache Karaf installation at " + baseFolder.getPath() + "...", -1);
        IRuntimeWorkingCopy runtime = KarafRuntimeLocator.getRuntimeFromDir(baseFolder, monitor);
        if (runtime != null) {
            listener.runtimeFound(runtime);
            foundRuntimes.put(karafJar.getPath(), runtime);
            valid = true;
        }
        monitor.worked(1);
        return valid;
    }

    public static IRuntimeWorkingCopy getRuntimeFromDir(File dir, IProgressMonitor monitor) {
        int i = 0;
        while (i < IKarafRuntime.KARAF_RUNTIME_TYPES_SUPPORTED.length) {
            try {
                IRuntimeType runtimeType = ServerCore.findRuntimeType((String)IKarafRuntime.KARAF_RUNTIME_TYPES_SUPPORTED[i]);
                String absolutePath = dir.getAbsolutePath();
                if (KarafUtils.isValidKarafInstallation(dir, null)) {
                    IRuntimeWorkingCopy runtime = runtimeType.createRuntime(runtimeType.getId(), monitor);
                    runtime.setLocation((IPath)new Path(absolutePath));
                    IKarafRuntimeWorkingCopy wc = (IKarafRuntimeWorkingCopy)runtime.loadAdapter(IKarafRuntimeWorkingCopy.class, null);
                    wc.setKarafInstallDir(absolutePath);
                    wc.setKarafVersion(KarafUtils.getVersion(dir));
                    wc.setKarafPropertiesFileLocation("");
                    runtime.save(true, monitor);
                    IStatus status = runtime.validate(monitor);
                    if (status == null || status.getSeverity() != 4) {
                        return runtime;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return null;
    }
}

