/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.core.internal.runtime;

import com.fusesource.rider.server.karaf.core.internal.KarafUtils;
import com.fusesource.rider.server.karaf.core.internal.ServiceMixUtils;
import com.fusesource.rider.server.karaf.core.internal.runtime.IKarafRuntime;
import com.fusesource.rider.server.karaf.core.internal.runtime.IKarafRuntimeWorkingCopy;
import com.fusesource.rider.server.karaf.core.internal.runtime.KarafRuntimeLocator;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class ServiceMix4xRuntimeLocator
extends KarafRuntimeLocator {
    public static IRuntimeWorkingCopy getRuntimeFromDir(File dir, IProgressMonitor monitor) {
        int i = 0;
        while (i < IKarafRuntime.SMX_RUNTIME_TYPES_SUPPORTED.length) {
            try {
                IRuntimeType runtimeType = ServerCore.findRuntimeType((String)IKarafRuntime.SMX_RUNTIME_TYPES_SUPPORTED[i]);
                String absolutePath = dir.getAbsolutePath();
                if (ServiceMixUtils.isValidServiceMixInstallation(dir, null)) {
                    IRuntimeWorkingCopy runtime = runtimeType.createRuntime(runtimeType.getId(), monitor);
                    runtime.setLocation((IPath)new Path(absolutePath));
                    IKarafRuntimeWorkingCopy wc = (IKarafRuntimeWorkingCopy)runtime.loadAdapter(IKarafRuntimeWorkingCopy.class, null);
                    wc.setKarafInstallDir(absolutePath);
                    wc.setKarafVersion(KarafUtils.getVersion(dir));
                    wc.setKarafPropertiesFileLocation("");
                    runtime.save(true, monitor);
                    IStatus status = runtime.validate(monitor);
                    if (status == null || status.getSeverity() != 4) {
                        return runtime;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return null;
    }
}

