/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.core.internal.server;

import com.fusesource.rider.server.karaf.core.internal.runtime.IKarafRuntime;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class KarafServerBehaviourDelegate
extends ServerBehaviourDelegate {
    public static final String QUOTE = "\"";
    public static final String SPACE = " ";
    public static final String SEPARATOR = File.separator;
    public static final String KARAF_MAIN_CLASS = "org.apache.karaf.main.Main";
    public static final String KARAF_STOP_CLASS = "org.apache.karaf.main.Stop";
    private IProcess process;

    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        this.setServerState(4);
    }

    public void dispose() {
        this.stop(true);
        super.dispose();
    }

    public void setupLaunch(String mode) {
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(mode);
    }

    public void setLaunched() {
        this.setServerState(2);
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        String mainType = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        if (!"".equals(mainType)) {
            return;
        }
        IKarafRuntime runtime = null;
        if (this.getServer().getRuntime() != null) {
            runtime = (IKarafRuntime)this.getServer().getRuntime().loadAdapter(IKarafRuntime.class, null);
        }
        if (runtime != null) {
            String karafInstallDir = runtime.getKarafInstallDir();
            String vmArguments = this.getVMArguments(karafInstallDir);
            String mainProgram = this.getMainProgram();
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, karafInstallDir);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainProgram);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
            LinkedList<String> classPathList = new LinkedList<String>();
            String[] classPathEntries = this.getClassPathEntries(karafInstallDir);
            if (classPathEntries != null && classPathEntries.length > 0) {
                String[] stringArray = classPathEntries;
                int n = classPathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    String jarName = stringArray[n2];
                    Path jarPath = new Path(jarName);
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jarPath);
                    classPathList.add(entry.getMemento());
                    ++n2;
                }
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classPathList);
        }
    }

    public void setKarafProcess(IProcess proc, IProgressMonitor monitor) {
        this.process = proc;
    }

    public void stop(boolean force) {
        if (this.getServer().getServerState() == 3 || this.getServer().getServerState() == 4) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                KarafServerBehaviourDelegate.this.setServerState(3);
            }
        });
        if (this.process != null) {
            try {
                this.process.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            this.process = null;
        }
        this.getServer().stop(false);
        this.setServerState(4);
        this.setModulesStopped();
    }

    protected void setModulesStopped() {
        IModule[] modules = this.getServer().getModules();
        if (modules != null && modules.length > 0) {
            IModule[] iModuleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule mod = iModuleArray[n2];
                this.setModuleState(new IModule[]{mod}, 4);
                ++n2;
            }
        }
    }

    protected String[] getClassPathEntries(String installPath) {
        ArrayList cp = new ArrayList();
        Path libPath = new Path(String.format("%s%s%s%s", installPath, SEPARATOR, "lib", SEPARATOR));
        if (libPath.toFile().exists()) {
            this.findJars((IPath)libPath, cp);
        }
        String[] entries = new String[cp.size() + 1];
        entries[0] = String.valueOf(installPath) + SEPARATOR + "etc";
        int i = 1;
        for (Object o : cp) {
            IRuntimeClasspathEntry e = (IRuntimeClasspathEntry)o;
            entries[i++] = e.getLocation();
        }
        return entries;
    }

    private void findJars(IPath path, List cp) {
        File[] libs;
        File[] fileArray = libs = path.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.isFile() && pathname.getName().toLowerCase().endsWith(".jar");
            }
        });
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            File lib = fileArray[n2];
            IPath p = path.append(lib.getName());
            if (lib.isFile()) {
                cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)p));
            } else {
                this.findJars(p, cp);
            }
            ++n2;
        }
    }

    protected String getDeployDir() {
        IKarafRuntime runtime = (IKarafRuntime)this.getServer().getRuntime().loadAdapter(IKarafRuntime.class, null);
        if (runtime != null) {
            String karafInstallDir = runtime.getKarafInstallDir();
            return String.valueOf(karafInstallDir) + SEPARATOR + "deploy";
        }
        return "";
    }

    protected String getMainProgram() {
        return KARAF_MAIN_CLASS;
    }

    protected String getVMArguments(String karafInstallDir) {
        StringBuilder vmArguments = new StringBuilder();
        vmArguments.append("-Xms128M  -Xmx512M ");
        vmArguments.append(" -Dderby.system.home=\"" + karafInstallDir + SEPARATOR + "data" + SEPARATOR + "derby" + QUOTE);
        vmArguments.append(" -Dderby.storage.fileSyncTransactionLog=true");
        vmArguments.append(" -Dkaraf.startLocalConsole=false");
        vmArguments.append(" -Dkaraf.startRemoteShell=true");
        vmArguments.append(" -Dkaraf.home=\"" + karafInstallDir + QUOTE);
        vmArguments.append(" -Dkaraf.base=\"" + karafInstallDir + QUOTE);
        vmArguments.append(" -Dkaraf.instances=\"" + karafInstallDir + SEPARATOR + "instances" + QUOTE);
        vmArguments.append(" -Dkaraf.data=\"" + karafInstallDir + SEPARATOR + "data" + QUOTE);
        vmArguments.append(" -Djava.util.logging.config.file=\"" + karafInstallDir + SEPARATOR + "etc" + SEPARATOR + "java.util.logging.properties" + QUOTE);
        return vmArguments.toString();
    }
}

