/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.navigator;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.wizards.PublishTemplateWizard;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class PublishTemplateNavigatorAction
implements IViewActionDelegate {
    protected ResourceNavigator navigator;

    public void init(IViewPart view) {
        if (view instanceof ResourceNavigator) {
            this.navigator = (ResourceNavigator)view;
        }
    }

    public void run(IAction action) {
        IFile file = this.getSelectedFile();
        if (file != null) {
            String url = file.getLocation().toOSString();
            try {
                ReportDesignHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(url);
                if (handle == null) {
                    action.setEnabled(false);
                    return;
                }
                IEditorPart editor = org.eclipse.birt.report.designer.internal.ui.util.UIUtil.findOpenedEditor((String)url);
                if (editor != null && editor.isDirty()) {
                    MessageDialog md = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"PublishTemplateAction.SaveBeforeGenerating.dialog.title"), null, Messages.getFormattedString((String)"PublishTemplateAction.SaveBeforeGenerating.dialog.message", (Object[])new Object[]{file.getName()}), 5, new String[]{Messages.getString((String)"PublishTemplateAction.SaveBeforeGenerating.dialog.button.yes"), Messages.getString((String)"PublishTemplateAction.SaveBeforeGenerating.dialog.button.no")}, 0);
                    switch (md.open()) {
                        case 0: {
                            editor.doSave(null);
                        }
                    }
                }
                WizardDialog dialog = new WizardDialog(UIUtil.getDefaultShell(), (IWizard)new PublishTemplateWizard(handle));
                dialog.setPageSize(500, 250);
                dialog.open();
                handle.close();
            }
            catch (Exception e) {
                ExceptionUtil.handle((Throwable)e);
                return;
            }
        } else {
            action.setEnabled(false);
        }
    }

    protected IFile getSelectedFile() {
        IStructuredSelection selection;
        if (this.navigator != null && (selection = (IStructuredSelection)this.navigator.getTreeViewer().getSelection()).size() == 1 && selection.getFirstElement() instanceof IFile) {
            return (IFile)selection.getFirstElement();
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

