/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class CreateFileChange
extends JDTChange {
    private String fChangeName;
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;
    private long fStampToRestore;

    public CreateFileChange(IPath path, String source, String encoding) {
        this(path, source, encoding, -1L);
    }

    public CreateFileChange(IPath path, String source, String encoding, long stampToRestore) {
        Assert.isNotNull((Object)path, (String)"path");
        Assert.isNotNull((Object)source, (String)"source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
        this.fStampToRestore = stampToRestore;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull((Object)encoding, (String)"encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    public String getName() {
        if (this.fChangeName == null) {
            return Messages.format(NLSChangesMessages.createFile_Create_file, this.fPath.toOSString());
        }
        return this.fChangeName;
    }

    public void setName(String name) {
        this.fChangeName = name;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    protected String getSource() {
        return this.fSource;
    }

    protected void setPath(IPath path) {
        this.fPath = path;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
        URI location = file.getLocationURI();
        if (location == null) {
            result.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_unknownLocation, file.getFullPath().toString()));
            return result;
        }
        IFileInfo jFile = EFS.getStore((URI)location).fetchInfo();
        if (jFile.exists()) {
            result.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_exists, file.getFullPath().toString()));
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        is = null;
        try {
            pm.beginTask(NLSChangesMessages.createFile_creating_resource, 3);
            this.initializeEncoding();
            file = this.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
            try {
                is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                file.create(is, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (this.fStampToRestore != -1L) {
                    file.revertModificationStamp(this.fStampToRestore);
                }
                if (this.fExplicitEncoding) {
                    file.setCharset(this.fEncoding, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    pm.worked(1);
                }
                var7_4 = new DeleteFileChange(file);
            }
            catch (UnsupportedEncodingException e) {
                throw new JavaScriptModelException((Throwable)e, 985);
            }
            var5_5 = null;
            ** GOTO lbl-1000
        }
        catch (Throwable var6_14) {
            var5_6 = null;
            try {
                try {
                    if (is != null) {
                        is.close();
                    }
                    ** GOTO lbl52
                }
                catch (IOException ioe) {
                    throw new JavaScriptModelException((Throwable)ioe, 985);
                }
            }
            catch (Throwable var10_10) {
                v0 = null;
lbl33:
                // 2 sources

                while (true) {
                    var9_12 = v0;
                    pm.done();
                    throw var6_14;
                }
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Throwable var10_9) {
                v1 = null;
lbl40:
                // 2 sources

                while (true) {
                    var9_11 = v1;
                    pm.done();
                    return var7_4;
                }
            }
            try {}
            catch (IOException ioe) {
                throw new JavaScriptModelException((Throwable)ioe, 985);
            }
            if (is != null) {
                is.close();
            }
            {
                v1 = null;
                ** continue;
lbl52:
                // 1 sources

                v0 = null;
                ** continue;
            }
        }
    }

    protected IFile getOldFile(IProgressMonitor pm) throws OperationCanceledException {
        IFile iFile;
        pm.beginTask("", 1);
        try {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iFile;
    }

    private void initializeEncoding() {
        if (this.fEncoding == null) {
            this.fExplicitEncoding = false;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            if (file != null) {
                try {
                    if (file.exists()) {
                        this.fEncoding = file.getCharset(false);
                        if (this.fEncoding == null) {
                            this.fEncoding = file.getCharset(true);
                        } else {
                            this.fExplicitEncoding = true;
                        }
                    } else {
                        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                        if (contentType != null) {
                            this.fEncoding = contentType.getDefaultCharset();
                        }
                        if (this.fEncoding == null) {
                            this.fEncoding = file.getCharset(true);
                        }
                    }
                }
                catch (CoreException coreException) {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            } else {
                this.fEncoding = ResourcesPlugin.getEncoding();
                this.fExplicitEncoding = true;
            }
        }
        Assert.isNotNull((Object)this.fEncoding);
    }
}

