/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.archetype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.archetype.catalog.Archetype;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogsWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchetypeManager {
    private final Map<String, ArchetypeCatalogFactory> catalogs = new LinkedHashMap<String, ArchetypeCatalogFactory>();
    private final File configFile;
    private final ArchetypeCatalogsWriter writer;

    public ArchetypeManager(File configFile) {
        this.configFile = configFile;
        this.writer = new ArchetypeCatalogsWriter();
    }

    public Collection<ArchetypeCatalogFactory> getArchetypeCatalogs() {
        return new ArrayList<ArchetypeCatalogFactory>(this.catalogs.values());
    }

    public void addArchetypeCatalogFactory(ArchetypeCatalogFactory factory) {
        if (factory != null) {
            this.catalogs.put(factory.getId(), factory);
        }
    }

    public void removeArchetypeCatalogFactory(String catalogId) {
        this.catalogs.remove(catalogId);
    }

    public ArchetypeCatalogFactory getArchetypeCatalogFactory(String catalogId) {
        return this.catalogs.get(catalogId);
    }

    public void readCatalogs() throws IOException {
        if (this.configFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.configFile);
                Collection<ArchetypeCatalogFactory> catalogs = this.writer.readArchetypeCatalogs(is);
                Iterator<ArchetypeCatalogFactory> it = catalogs.iterator();
                while (it.hasNext()) {
                    this.addArchetypeCatalogFactory(it.next());
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
        }
    }

    public void saveCatalogs() throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.configFile);
            this.writer.writeArchetypeCatalogs(this.getArchetypeCatalogs(), os);
        }
        catch (Throwable throwable) {
            IOUtil.close(os);
            throw throwable;
        }
        IOUtil.close((OutputStream)os);
    }

    public <T extends ArchetypeCatalogFactory> T findParentCatalogFactory(Archetype a, Class<T> type) throws CoreException {
        if (a != null) {
            for (ArchetypeCatalogFactory factory : this.getArchetypeCatalogs()) {
                if (!type.isAssignableFrom(factory.getClass()) || factory.getDescription() != null && factory.getDescription().startsWith("Test") || !factory.getArchetypeCatalog().getArchetypes().contains(a)) continue;
                return (T)factory;
            }
        }
        return null;
    }
}

