/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.embedder.IMavenComponentContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtensionModule
extends AbstractModule
implements IMavenComponentContributor.IMavenComponentBinder {
    private static final Logger log = LoggerFactory.getLogger(ExtensionModule.class);

    ExtensionModule() {
    }

    @Override
    public <T> void bind(Class<T> role, Class<? extends T> impl, String hint) {
        if (hint == null || hint.length() <= 0 || "default".equals(hint)) {
            this.bind(role).to(impl);
        } else {
            this.bind(role).annotatedWith((Annotation)Names.named((String)hint)).to(impl);
        }
    }

    protected void configure() {
        IExtensionRegistry r = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = r.getConfigurationElementsFor("org.eclipse.m2e.core.mavenComponentContributors");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement c = iConfigurationElementArray[n2];
            if ("configurator".equals(c.getName())) {
                try {
                    IMavenComponentContributor contributor = (IMavenComponentContributor)c.createExecutableExtension("class");
                    contributor.contribute(this);
                }
                catch (CoreException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
            ++n2;
        }
    }
}

