/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.markers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.markers.ArtifactNotFoundProblemInfo;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MarkerUtils;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.transfer.ArtifactNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenMarkerManager
implements IMavenMarkerManager {
    private static Logger log = LoggerFactory.getLogger(MavenMarkerManager.class);
    private final IMavenConfiguration mavenConfiguration;

    public MavenMarkerManager(IMavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
    }

    @Override
    public void addMarkers(IResource pomResource, String type, MavenExecutionResult result) {
        SourceLocation defaultSourceLocation = new SourceLocation(1, 0, 0);
        ArrayList<MavenProblemInfo> allProblems = new ArrayList<MavenProblemInfo>();
        allProblems.addAll(this.toMavenProblemInfos(pomResource, defaultSourceLocation, result.getExceptions()));
        MavenProject mavenProject = result.getProject();
        DependencyResolutionResult resolutionResult = result.getDependencyResolutionResult();
        if (resolutionResult != null) {
            allProblems.addAll(this.toMavenProblemInfos(pomResource, defaultSourceLocation, resolutionResult.getCollectionErrors()));
            for (Dependency dependency : resolutionResult.getUnresolvedDependencies()) {
                List exceptions = resolutionResult.getResolutionErrors(dependency);
                if (exceptions == null || exceptions.size() <= 0) continue;
                SourceLocation sourceLocation = SourceLocationHelper.findLocation(mavenProject, dependency);
                allProblems.addAll(this.toMavenProblemInfos(pomResource, sourceLocation, exceptions));
            }
        }
        if (mavenProject != null) {
            this.addMissingArtifactProblemInfos(mavenProject, defaultSourceLocation, allProblems);
        }
        this.addErrorMarkers(pomResource, type, allProblems);
    }

    @Override
    public IMarker addMarker(IResource resource, String type, String message, int lineNumber, int severity) {
        return this.addMarker(resource, type, message, lineNumber, severity, false);
    }

    private IMarker addMarker(IResource resource, String type, String message, int lineNumber, int severity, boolean isTransient) {
        IMarker marker = null;
        try {
            if (resource.isAccessible()) {
                if (lineNumber == -1) {
                    lineNumber = 1;
                }
                if ((marker = this.findMarker(resource, type, message, lineNumber, severity, isTransient)) != null) {
                    return marker;
                }
                marker = resource.createMarker(type);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", severity);
                marker.setAttribute("transient", isTransient);
                marker.setAttribute("lineNumber", lineNumber);
                log.debug("Created marker '{}' on resource '{}'.", (Object)message, (Object)resource.getFullPath());
            }
        }
        catch (CoreException ex) {
            log.error("Unable to add marker; " + ex.toString(), (Throwable)ex);
        }
        return marker;
    }

    private static <T> boolean eq(T a, T b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private IMarker findMarker(IResource resource, String type, String message, int lineNumber, int severity, boolean isTransient) throws CoreException {
        IMarker[] markers = resource.findMarkers(type, false, 0);
        if (markers == null || markers.length == 0) {
            return null;
        }
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (MavenMarkerManager.eq(message, marker.getAttribute("message")) && MavenMarkerManager.eq(lineNumber, marker.getAttribute("lineNumber")) && MavenMarkerManager.eq(severity, marker.getAttribute("severity")) && MavenMarkerManager.eq(isTransient, marker.getAttribute("transient"))) {
                return marker;
            }
            ++n2;
        }
        return null;
    }

    private String getArtifactId(AbstractArtifactResolutionException rex) {
        String id = String.valueOf(rex.getGroupId()) + ":" + rex.getArtifactId() + ":" + rex.getVersion();
        if (rex.getClassifier() != null) {
            id = String.valueOf(id) + ":" + rex.getClassifier();
        }
        if (rex.getType() != null) {
            id = String.valueOf(id) + ":" + rex.getType();
        }
        return id;
    }

    private String getRootErrorMessage(Throwable ex) {
        return this.getRootCause(ex).getMessage();
    }

    private String getErrorMessage(Throwable ex) {
        StringBuilder message = new StringBuilder();
        while (ex != null) {
            if (ex.getMessage() != null && message.indexOf(ex.getMessage()) < 0) {
                if (message.length() > 0) {
                    message.append(": ");
                }
                message.append(ex.getClass().getSimpleName()).append(": ").append(ex.getMessage());
            }
            ex = ex.getCause();
        }
        return message.toString();
    }

    private Throwable getRootCause(Throwable ex) {
        Throwable lastCause = ex;
        Throwable cause = lastCause.getCause();
        while (cause != null && cause != lastCause) {
            if (cause instanceof org.apache.maven.artifact.resolver.ArtifactNotFoundException) {
                cause = null;
                continue;
            }
            lastCause = cause;
            cause = cause.getCause();
        }
        return cause == null ? lastCause : cause;
    }

    private List<MavenProblemInfo> toMavenProblemInfos(IResource pomResource, SourceLocation location, List<? extends Throwable> exceptions) {
        ArrayList<MavenProblemInfo> result = new ArrayList<MavenProblemInfo>();
        if (exceptions == null) {
            return result;
        }
        for (Throwable throwable : exceptions) {
            if (throwable instanceof ArtifactNotFoundException) {
                ArtifactNotFoundException artifactNotFoundException = (ArtifactNotFoundException)throwable;
                ArtifactNotFoundProblemInfo problem = new ArtifactNotFoundProblemInfo(artifactNotFoundException.getArtifact(), this.mavenConfiguration.isOffline(), location);
                result.add(problem);
                continue;
            }
            if (throwable instanceof AbstractArtifactResolutionException) {
                AbstractArtifactResolutionException abstractArtifactResolutionException = (AbstractArtifactResolutionException)throwable;
                String errorMessage = String.valueOf(this.getArtifactId(abstractArtifactResolutionException)) + " " + this.getRootErrorMessage(throwable);
                result.add(new MavenProblemInfo(errorMessage, location));
                continue;
            }
            if (throwable instanceof ProjectBuildingException) {
                Throwable cause = throwable.getCause();
                if (cause instanceof ModelBuildingException) {
                    ModelBuildingException mbe = (ModelBuildingException)cause;
                    for (ModelProblem problem : mbe.getProblems()) {
                        String message = NLS.bind((String)Messages.pluginMarkerBuildError, (Object)problem.getMessage());
                        int severity = ModelProblem.Severity.WARNING == problem.getSeverity() ? 1 : 2;
                        SourceLocation problemLocation = SourceLocationHelper.findLocation(pomResource, problem);
                        result.add(new MavenProblemInfo(message, severity, problemLocation));
                    }
                    continue;
                }
                result.add(new MavenProblemInfo(this.getErrorMessage(throwable), location));
                continue;
            }
            result.add(new MavenProblemInfo(this.getErrorMessage(throwable), location));
        }
        return result;
    }

    @Override
    public void deleteMarkers(IResource resource, String type) throws CoreException {
        this.deleteMarkers(resource, true, type);
    }

    @Override
    public void deleteMarkers(IResource resource, boolean includeSubtypes, String type) throws CoreException {
        if (resource != null && resource.exists()) {
            resource.deleteMarkers(type, includeSubtypes, 2);
        }
    }

    @Override
    public void deleteMarkers(IResource resource, String type, String attrName, String attrValue) throws CoreException {
        IMarker[] markers;
        if (resource == null || !resource.exists()) {
            return;
        }
        IMarker[] iMarkerArray = markers = resource.findMarkers(type, false, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (MavenMarkerManager.eq(attrValue, marker.getAttribute(attrName))) {
                marker.delete();
            }
            ++n2;
        }
    }

    private void addMissingArtifactProblemInfos(MavenProject mavenProject, SourceLocation location, List<MavenProblemInfo> knownProblems) {
        Set artifacts = mavenProject.getArtifacts();
        block0: for (org.apache.maven.artifact.Artifact mavenArtifact : artifacts) {
            if (mavenArtifact.isResolved()) continue;
            Artifact artifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)mavenArtifact);
            for (MavenProblemInfo problem : knownProblems) {
                ArtifactNotFoundProblemInfo artifactNotFoundProblemInfo;
                if (problem instanceof ArtifactNotFoundProblemInfo && MavenMarkerManager.equals((artifactNotFoundProblemInfo = (ArtifactNotFoundProblemInfo)problem).getArtifact(), artifact)) continue block0;
            }
            knownProblems.add(new ArtifactNotFoundProblemInfo(artifact, this.mavenConfiguration.isOffline(), location));
        }
    }

    @Override
    public void addErrorMarkers(IResource resource, String type, Exception ex) {
        Throwable cause = this.getRootCause(ex);
        if (cause instanceof CoreException) {
            CoreException cex = (CoreException)cause;
            IStatus status = cex.getStatus();
            if (status != null) {
                this.addMarker(resource, type, status.getMessage(), 1, 2, false);
                IStatus[] children = status.getChildren();
                if (children != null) {
                    IStatus[] iStatusArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus childStatus = iStatusArray[n2];
                        this.addMarker(resource, type, childStatus.getMessage(), 1, 2, false);
                        ++n2;
                    }
                }
            }
        } else {
            this.addMarker(resource, type, cause.getMessage(), 1, 2, false);
        }
    }

    @Override
    public void addErrorMarkers(IResource resource, String type, List<MavenProblemInfo> problems) {
        for (MavenProblemInfo problem : problems) {
            this.addErrorMarker(resource, type, problem);
        }
    }

    @Override
    public void addErrorMarker(IResource resource, String type, MavenProblemInfo problem) {
        IMarker marker = this.addMarker(resource, type, problem.getMessage(), problem.getLocation().getLineNumber(), problem.getSeverity());
        try {
            problem.processMarker(marker);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        MarkerUtils.decorateMarker(marker);
    }

    private static boolean equals(Artifact a1, Artifact a2) {
        if (a1 == a2) {
            return true;
        }
        return a1.getArtifactId().equals(a2.getArtifactId()) && a1.getGroupId().equals(a2.getGroupId()) && a1.getVersion().equals(a2.getVersion()) && a1.getExtension().equals(a2.getExtension()) && a1.getClassifier().equals(a2.getClassifier());
    }
}

