/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeManager;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.project.LifecycleMappingConfiguration;
import org.eclipse.m2e.core.internal.project.MavenProjectImportResult;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConfigurationManager
implements IProjectConfigurationManager,
IMavenProjectChangedListener,
IResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectConfigurationManager.class);
    final ProjectRegistryManager projectManager;
    final MavenModelManager mavenModelManager;
    final IMavenMarkerManager mavenMarkerManager;
    final IMaven maven;
    final IMavenConfiguration mavenConfiguration;

    public ProjectConfigurationManager(IMaven maven, ProjectRegistryManager projectManager, MavenModelManager mavenModelManager, IMavenMarkerManager mavenMarkerManager, IMavenConfiguration mavenConfiguration) {
        this.projectManager = projectManager;
        this.mavenModelManager = mavenModelManager;
        this.mavenMarkerManager = mavenMarkerManager;
        this.maven = maven;
        this.mavenConfiguration = mavenConfiguration;
    }

    @Override
    public List<IMavenProjectImportResult> importProjects(Collection<MavenProjectInfo> projectInfos, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        long t1 = System.currentTimeMillis();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectConfigurationManager_task_importing, (int)100);
        ArrayList<IMavenProjectImportResult> result = new ArrayList<IMavenProjectImportResult>();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(10), (int)(projectInfos.size() * 100));
        for (MavenProjectInfo projectInfo : projectInfos) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IProject project = this.create(projectInfo, configuration, (IProgressMonitor)subProgress.newChild(100));
            result.add(new MavenProjectImportResult(projectInfo, project));
            if (project == null) continue;
            projects.add(project);
        }
        this.hideNestedProjectsFromParents(projects);
        this.configureNewMavenProject(projects, (IProgressMonitor)progress.newChild(90));
        long t2 = System.currentTimeMillis();
        log.info("Project import completed " + (t2 - t1) / 1000L + " sec");
        return result;
    }

    private void setHidden(IResource resource) {
        try {
            resource.setHidden(true);
        }
        catch (Exception ex) {
            log.error("Failed to hide resource; " + resource.getLocation().toOSString(), (Throwable)ex);
        }
    }

    private void hideNestedProjectsFromParents(List<IProject> projects) {
        if (!MavenPlugin.getMavenConfiguration().isHideFoldersOfNestedProjects()) {
            return;
        }
        HashMap<File, IProject> projectFileMap = new HashMap<File, IProject>();
        for (IProject project : projects) {
            projectFileMap.put(project.getLocation().toFile(), project);
        }
        for (IProject project : projects) {
            IFolder folder;
            File projectFile = project.getLocation().toFile();
            IProject physicalParentProject = (IProject)projectFileMap.get(projectFile.getParentFile());
            if (physicalParentProject == null || !(folder = physicalParentProject.getFolder(projectFile.getName())).exists()) continue;
            this.setHidden((IResource)folder);
        }
    }

    private void configureNewMavenProject(List<IProject> projects, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectConfigurationManager_task_configuring, (int)100);
        MavenUpdateRequest updateRequest = new MavenUpdateRequest(this.mavenConfiguration.isOffline(), false);
        for (IProject project : projects) {
            updateRequest.addPomFile(project);
        }
        progress.subTask(Messages.ProjectConfigurationManager_task_refreshing);
        this.projectManager.refresh(updateRequest, (IProgressMonitor)progress.newChild(75));
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(5), (int)(projects.size() * 100));
        ArrayList<IMavenProjectFacade> facades = new ArrayList<IMavenProjectFacade>(projects.size());
        for (IProject project : projects) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            MavenProjectFacade facade = this.projectManager.create(project, (IProgressMonitor)subProgress.newChild(100));
            if (facade == null) continue;
            facades.add(facade);
        }
        this.sortProjects(facades, (IProgressMonitor)progress.newChild(5));
        subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(15), (int)(facades.size() * 100));
        for (IMavenProjectFacade facade : facades) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            progress.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_updating, (Object)facade.getProject().getName()));
            MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)subProgress.newChild(5));
            MavenSession mavenSession = this.createMavenSession(facade, (IProgressMonitor)subProgress.newChild(5));
            ProjectConfigurationRequest request = new ProjectConfigurationRequest(facade, mavenProject, mavenSession);
            this.updateProjectConfiguration(request, (IProgressMonitor)subProgress.newChild(90));
        }
    }

    private MavenSession createMavenSession(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        MavenExecutionRequest request = this.projectManager.createExecutionRequest(facade.getPom(), facade.getResolverConfiguration(), monitor);
        return this.maven.createSession(request, facade.getMavenProject(monitor));
    }

    public void sortProjects(List<IMavenProjectFacade> facades, IProgressMonitor monitor) throws CoreException {
        HashMap<MavenProject, IMavenProjectFacade> mavenProjectToFacadeMap = new HashMap<MavenProject, IMavenProjectFacade>(facades.size());
        for (IMavenProjectFacade facade : facades) {
            mavenProjectToFacadeMap.put(facade.getMavenProject(monitor), facade);
        }
        facades.clear();
        for (MavenProject mavenProject : this.maven.getSortedProjects(new ArrayList<MavenProject>(mavenProjectToFacadeMap.keySet()))) {
            facades.add((IMavenProjectFacade)mavenProjectToFacadeMap.get(mavenProject));
        }
    }

    @Override
    public void updateProjectConfiguration(IProject project, IProgressMonitor monitor) throws CoreException {
        this.updateProjectConfiguration(new MavenUpdateRequest(project, this.mavenConfiguration.isOffline(), false), monitor);
    }

    @Override
    public void updateProjectConfiguration(MavenUpdateRequest request, IProgressMonitor monitor) throws CoreException {
        if (request.getPomFiles().size() != 1) {
            throw new IllegalArgumentException();
        }
        this.projectManager.refresh(request, monitor);
        MavenProjectFacade facade = this.projectManager.create(request.getPomFiles().iterator().next(), false, monitor);
        if (facade != null) {
            ProjectConfigurationRequest cfgRequest = new ProjectConfigurationRequest(facade, facade.getMavenProject(monitor), this.createMavenSession(facade, monitor));
            this.updateProjectConfiguration(cfgRequest, monitor);
        }
    }

    private void updateProjectConfiguration(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.getProject();
        long start = System.currentTimeMillis();
        IMavenProjectFacade mavenProjectFacade = request.getMavenProjectFacade();
        log.debug("Updating project configuration for {}.", (Object)mavenProjectFacade.toString());
        this.addMavenNature(project, monitor);
        MavenProject mavenProject = request.getMavenProject();
        Properties mavenProperties = mavenProject.getProperties();
        String sourceEncoding = mavenProperties.getProperty("project.build.sourceEncoding");
        log.debug("Setting encoding for project {}: {}", (Object)project.getName(), (Object)sourceEncoding);
        project.setDefaultCharset(sourceEncoding, monitor);
        ILifecycleMapping lifecycleMapping = this.getLifecycleMapping(mavenProjectFacade);
        if (lifecycleMapping != null) {
            this.mavenMarkerManager.deleteMarkers((IResource)mavenProjectFacade.getProject(), "org.eclipse.m2e.core.maven2Problem.configuration");
            lifecycleMapping.configure(request, monitor);
            LifecycleMappingConfiguration.persist(request.getMavenProjectFacade(), monitor);
        } else {
            log.debug("LifecycleMapping is null for project {}", (Object)mavenProjectFacade.toString());
        }
        log.debug("Updated project configuration for {} in {} ms.", (Object)mavenProjectFacade.toString(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public void enableMavenNature(IProject project, ResolverConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.ProjectConfigurationManager_task_enable_nature);
        this.enableBasicMavenNature(project, configuration, monitor);
        ArrayList<IProject> projects = new ArrayList<IProject>();
        projects.add(project);
        this.configureNewMavenProject(projects, monitor);
    }

    private void enableBasicMavenNature(IProject project, ResolverConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ResolverConfigurationIO.saveResolverConfiguration(project, configuration);
        this.addMavenNature(project, monitor);
    }

    private void addMavenNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
            newNatures[0] = "org.eclipse.m2e.core.maven2Nature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    @Override
    public void disableMavenNature(IProject project, IProgressMonitor monitor) throws CoreException {
        ILifecycleMapping lifecycleMapping;
        monitor.subTask(Messages.ProjectConfigurationManager_task_disable_nature);
        MavenProjectFacade facade = this.projectManager.create(project, monitor);
        if (facade != null && (lifecycleMapping = this.getLifecycleMapping(facade)) != null) {
            ProjectConfigurationRequest request = new ProjectConfigurationRequest(facade, facade.getMavenProject(monitor), this.createMavenSession(facade, monitor));
            lifecycleMapping.unconfigure(request, monitor);
        }
        project.deleteMarkers("org.eclipse.m2e.core.maven2Problem", true, 2);
        IProjectDescription description = project.getDescription();
        ArrayList<String> newNatures = new ArrayList<String>();
        String[] stringArray = description.getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            if (!"org.eclipse.m2e.core.maven2Nature".equals(natureId)) {
                newNatures.add(natureId);
            }
            ++n2;
        }
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        this.removeMavenBuilder(project, description, monitor);
        project.setDescription(description, null);
    }

    @Override
    public boolean addMavenBuilder(IProject project, IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        boolean setProjectDescription = false;
        if (description == null) {
            description = project.getDescription();
            setProjectDescription = true;
        }
        ICommand mavenBuilder = null;
        ArrayList<ICommand> newSpec = new ArrayList<ICommand>();
        int i = 0;
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (this.isMavenBuilderCommand(project, command)) {
                mavenBuilder = command;
                if (i == description.getBuildSpec().length - 1) {
                    return false;
                }
            } else {
                newSpec.add(command);
            }
            ++i;
            ++n2;
        }
        if (mavenBuilder == null) {
            mavenBuilder = description.newCommand();
            mavenBuilder.setBuilderName("org.eclipse.m2e.core.maven2Builder");
        }
        newSpec.add(mavenBuilder);
        description.setBuildSpec(newSpec.toArray(new ICommand[newSpec.size()]));
        if (setProjectDescription) {
            project.setDescription(description, monitor);
        }
        return true;
    }

    @Override
    public boolean removeMavenBuilder(IProject project, IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        boolean setProjectDescription = false;
        if (description == null) {
            description = project.getDescription();
            setProjectDescription = true;
        }
        boolean foundMavenBuilder = false;
        ArrayList<ICommand> newSpec = new ArrayList<ICommand>();
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (!this.isMavenBuilderCommand(project, command)) {
                newSpec.add(command);
            } else {
                foundMavenBuilder = true;
            }
            ++n2;
        }
        if (!foundMavenBuilder) {
            return false;
        }
        description.setBuildSpec(newSpec.toArray(new ICommand[newSpec.size()]));
        if (setProjectDescription) {
            project.setDescription(description, monitor);
        }
        return true;
    }

    private boolean isMavenBuilderCommand(IProject project, ICommand command) {
        return "org.eclipse.m2e.core.maven2Builder".equals(command.getBuilderName());
    }

    @Override
    public void createSimpleProject(IProject project, IPath location, Model model, String[] directories, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String projectName = project.getName();
        monitor.beginTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_creating, (Object)projectName), 5);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_workspace);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setLocation(location);
        project.create(description, monitor);
        project.open(monitor);
        monitor.worked(1);
        this.hideNestedProjectsFromParents(Collections.singletonList(project));
        monitor.worked(1);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_pom);
        IFile pomFile = project.getFile("pom.xml");
        this.mavenModelManager.createMavenModel(pomFile, model);
        monitor.worked(1);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_folders);
        int i = 0;
        while (i < directories.length) {
            ProjectConfigurationManager.createFolder(project.getFolder(directories[i]), false);
            ++i;
        }
        monitor.worked(1);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_project);
        this.enableMavenNature(project, configuration.getResolverConfiguration(), monitor);
        monitor.worked(1);
    }

    public static void createFolder(IFolder folder, boolean derived) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent != null && !parent.exists()) {
                ProjectConfigurationManager.createFolder((IFolder)parent, false);
            }
            folder.create(true, true, null);
        }
        if (folder.isAccessible() && derived) {
            folder.setDerived(true);
        }
    }

    @Override
    public void createArchetypeProject(IProject project, IPath location, Archetype archetype, String groupId, String artifactId, String version, String javaPackage, Properties properties, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_creating_project1, (Object)project.getName()), 2);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        monitor.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_executing_archetype, (Object)archetype.getGroupId(), (Object)archetype.getArtifactId()));
        if (location == null) {
            location = workspaceRoot.getLocation();
        }
        try {
            ArchetypeGenerationResult result;
            Artifact artifact = this.resolveArchetype(archetype, monitor);
            ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setTransferListener(this.maven.createTransferListener(monitor)).setArchetypeGroupId(artifact.getGroupId()).setArchetypeArtifactId(artifact.getArtifactId()).setArchetypeVersion(artifact.getVersion()).setArchetypeRepository(archetype.getRepository()).setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setPackage(javaPackage).setLocalRepository(this.maven.getLocalRepository()).setRemoteArtifactRepositories(this.maven.getArtifactRepositories(true)).setProperties(properties).setOutputDirectory(location.toPortableString());
            MavenSession session = this.maven.createSession(this.maven.createExecutionRequest(monitor), null);
            MavenSession oldSession = MavenPluginActivator.getDefault().setSession(session);
            try {
                result = this.getArchetyper().generateProjectFromArchetype(request);
            }
            finally {
                MavenPluginActivator.getDefault().setSession(oldSession);
            }
            Exception cause = result.getCause();
            if (cause != null) {
                String msg = NLS.bind((String)Messages.ProjectConfigurationManager_error_unable_archetype, (Object)archetype.toString());
                log.error(msg, (Throwable)cause);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg, (Throwable)cause));
            }
            monitor.worked(1);
            String projectFolder = location.append(artifactId).toFile().getAbsolutePath();
            LocalProjectScanner scanner = new LocalProjectScanner(workspaceRoot.getLocation().toFile(), projectFolder, true, this.mavenModelManager);
            scanner.run(monitor);
            Set<MavenProjectInfo> projectSet = this.collectProjects(scanner.getProjects());
            this.importProjects(projectSet, configuration, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (InterruptedException interruptedException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e", Messages.ProjectConfigurationManager_error_failed, (Throwable)ex));
        }
    }

    private Artifact resolveArchetype(Archetype a, IProgressMonitor monitor) throws CoreException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        repos.addAll(this.maven.getArtifactRepositories());
        String artifactRemoteRepository = a.getRepository();
        try {
            ArchetypeManager archetypeManager;
            ArchetypeCatalogFactory.RemoteCatalogFactory factory;
            IMavenConfiguration mavenConfiguration;
            if (StringUtils.isBlank((String)artifactRemoteRepository) && !(mavenConfiguration = MavenPlugin.getMavenConfiguration()).isOffline() && (factory = (archetypeManager = MavenPluginActivator.getDefault().getArchetypeManager()).findParentCatalogFactory(a, ArchetypeCatalogFactory.RemoteCatalogFactory.class)) != null) {
                artifactRemoteRepository = factory.getRepositoryUrl();
                a.setRepository(artifactRemoteRepository);
            }
            if (StringUtils.isNotBlank((String)artifactRemoteRepository)) {
                ArtifactRepository archetypeRepository = this.maven.createArtifactRepository("archetype", a.getRepository().trim());
                repos.add(0, archetypeRepository);
            }
            this.maven.resolve(a.getGroupId(), a.getArtifactId(), a.getVersion(), "pom", null, repos, monitor);
            return this.maven.resolve(a.getGroupId(), a.getArtifactId(), a.getVersion(), "jar", null, repos, monitor);
        }
        catch (CoreException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.ProjectConfigurationManager_error_resolve).append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':').append(a.getVersion());
            sb.append(Messages.ProjectConfigurationManager_error_resolve2);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, sb.toString(), (Throwable)e));
        }
    }

    private org.apache.maven.archetype.Archetype getArchetyper() {
        return MavenPluginActivator.getDefault().getArchetype();
    }

    @Override
    public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
        return new LinkedHashSet<MavenProjectInfo>(){
            private static final long serialVersionUID = 1L;

            public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
                for (MavenProjectInfo projectInfo : projects) {
                    log.info("Collecting project info " + projectInfo);
                    this.add(projectInfo);
                    this.collectProjects(projectInfo.getProjects());
                }
                return this;
            }
        }.collectProjects(projects);
    }

    @Override
    public ISchedulingRule getRule() {
        return ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
    }

    private IProject create(MavenProjectInfo projectInfo, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        File pomFile = projectInfo.getPomFile();
        Model model = projectInfo.getModel();
        if (model == null) {
            model = this.maven.readModel(pomFile);
            projectInfo.setModel(model);
        }
        String projectName = configuration.getProjectName(model);
        File projectDir = pomFile.getParentFile();
        String projectParent = projectDir.getParentFile().getAbsolutePath();
        if (projectInfo.getBasedirRename() == 2) {
            File newProject = new File(projectDir.getParent(), projectName);
            if (!projectDir.equals(newProject)) {
                boolean renamed = projectDir.renameTo(newProject);
                if (!renamed) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(NLS.bind((String)Messages.ProjectConfigurationManager_error_rename, (Object)projectDir.getAbsolutePath())).append('.');
                    if (newProject.exists()) {
                        msg.append(NLS.bind((String)Messages.ProjectConfigurationManager_error_targetDir, (Object)newProject.getAbsolutePath()));
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg.toString(), null));
                }
                projectInfo.setPomFile(this.getCanonicalPomFile(newProject));
                projectDir = newProject;
            }
        } else if (projectParent.equals(root.getLocation().toFile().getAbsolutePath())) {
            projectName = projectDir.getName();
        }
        monitor.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_importing2, (Object)projectName));
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            log.error("Project " + projectName + " already exists");
            return null;
        }
        if (projectDir.equals(root.getLocation().toFile())) {
            log.error("Can't create project " + projectName + " at Workspace folder");
            return null;
        }
        if (projectParent.equals(root.getLocation().toFile().getAbsolutePath())) {
            project.create(monitor);
        } else {
            IProjectDescription description = workspace.newProjectDescription(projectName);
            description.setLocation((IPath)new Path(projectDir.getAbsolutePath()));
            project.create(description, monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        ResolverConfiguration resolverConfiguration = configuration.getResolverConfiguration();
        this.enableBasicMavenNature(project, resolverConfiguration, monitor);
        LifecycleMappingConfiguration.persistEmpty(project);
        return project;
    }

    private File getCanonicalPomFile(File projectDir) throws CoreException {
        try {
            return new File(projectDir.getCanonicalFile(), "pom.xml");
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.ProjectConfigurationManager_0, (Object)projectDir.getAbsolutePath()), null));
        }
    }

    @Override
    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        MavenProjectChangedEvent[] mavenProjectChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            MavenProjectChangedEvent event = mavenProjectChangedEventArray[n2];
            try {
                IMavenProjectFacade facade = event.getMavenProject();
                ILifecycleMapping lifecycleMapping = this.getLifecycleMapping(facade);
                if (lifecycleMapping != null) {
                    for (AbstractProjectConfigurator configurator : lifecycleMapping.getProjectConfigurators(facade, monitor)) {
                        configurator.mavenProjectChanged(event, monitor);
                    }
                }
                if (facade != null) {
                    LifecycleMappingConfiguration oldConfiguration = LifecycleMappingConfiguration.restore(facade, monitor);
                    if (oldConfiguration != null && LifecycleMappingFactory.isLifecycleMappingChanged(facade, oldConfiguration, monitor)) {
                        this.mavenMarkerManager.addMarker((IResource)facade.getProject(), "org.eclipse.m2e.core.maven2Problem.configuration", Messages.ProjectConfigurationUpdateRequired, -1, 2);
                    }
                } else {
                    IMavenProjectFacade oldFacade = event.getOldMavenProject();
                    if (oldFacade != null) {
                        this.mavenMarkerManager.deleteMarkers((IResource)oldFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.configuration");
                    }
                }
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public ILifecycleMapping getLifecycleMapping(IMavenProjectFacade projectFacade) throws CoreException {
        if (projectFacade == null) {
            return null;
        }
        return LifecycleMappingFactory.getLifecycleMapping(projectFacade);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 && event.getResource() instanceof IProject) {
            LifecycleMappingConfiguration.remove((IProject)event.getResource());
        }
    }

    @Override
    public ResolverConfiguration getResolverConfiguration(IProject project) {
        return ResolverConfigurationIO.readResolverConfiguration(project);
    }

    @Override
    public boolean setResolverConfiguration(IProject project, ResolverConfiguration configuration) {
        return ResolverConfigurationIO.saveResolverConfiguration(project, configuration);
    }

    private static interface A {
        public IAdaptable[] adaptElements(IAdaptable[] var1);
    }
}

