/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.contenttype;

import com.fusesource.rider.commons.contenttype.FindNamespaceHandlerSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.XMLContentDescriber;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class NamespaceXmlContentDescriberSupport
extends XMLContentDescriber {
    static final String RESULT = "com.fusesource.rider.commons.contenttype.XmlContentDescriber.result";
    static final String FOUND = "com.fusesource.rider.commons.contenttype.XmlContentDescriber.found";

    static boolean isProcessed(Map properties) {
        Boolean result = (Boolean)properties.get(RESULT);
        return result != null;
    }

    private int checkCriteria(InputSource contents, Map properties) throws IOException {
        if (!NamespaceXmlContentDescriberSupport.isProcessed(properties)) {
            this.fillContentProperties(contents, properties);
        }
        return this.checkCriteria(properties);
    }

    private int checkCriteria(Map properties) throws IOException {
        Boolean result = (Boolean)properties.get(RESULT);
        if (!result.booleanValue()) {
            return 1;
        }
        Boolean found = (Boolean)properties.get(FOUND);
        if (found == null || !found.booleanValue()) {
            return 1;
        }
        return 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(contents, description, new HashMap());
    }

    public int describe(InputStream contents, IContentDescription description, Map properties) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents), properties);
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        return this.describe(contents, description, new HashMap());
    }

    public int describe(Reader contents, IContentDescription description, Map properties) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents), properties);
    }

    void fillContentProperties(InputSource input, Map properties) throws IOException {
        FindNamespaceHandlerSupport xmlHandler = this.createNamespaceFinder();
        try {
            if (!xmlHandler.parseContents(input)) {
                properties.put(RESULT, Boolean.FALSE);
                return;
            }
        }
        catch (SAXException sAXException) {
            properties.put(RESULT, Boolean.FALSE);
            return;
        }
        catch (ParserConfigurationException e) {
            String message = ContentMessages.content_parserConfiguration;
            RuntimeLog.log((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, message, (Throwable)e));
            throw new RuntimeException(message);
        }
        properties.put(FOUND, xmlHandler.isNamespaceFound() ? Boolean.TRUE : Boolean.FALSE);
        properties.put(RESULT, Boolean.TRUE);
    }

    protected abstract FindNamespaceHandlerSupport createNamespaceFinder();
}

