/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.contenttype;

import com.fusesource.rider.commons.Activator;
import com.fusesource.rider.commons.contenttype.FindNamespaceHandlerSupport;
import com.fusesource.rider.commons.util.IFiles;
import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.xml.sax.InputSource;

public abstract class XmlMatchingStrategySupport
implements IEditorMatchingStrategy {
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IFile ifile = ((IFileEditorInput)input).getFile();
            return this.matches(ifile);
        }
        return false;
    }

    public boolean matches(IFile ifile) {
        try {
            File file = IFiles.toFile(ifile);
            if (file != null) {
                FindNamespaceHandlerSupport handler = this.createNamespaceFinder();
                handler.parseContents(new InputSource(new FileInputStream(file)));
                return handler.isNamespaceFound();
            }
        }
        catch (Exception e) {
            Activator.getLogger().error("** Load failed. Using default model. **", e);
        }
        return false;
    }

    protected abstract FindNamespaceHandlerSupport createNamespaceFinder();
}

