/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.properties;

import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.ReturnType;
import java.beans.PropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.camel.rider.util.Strings;

public class PropertyDescriptors {
    public static String getReadablePropertyName(IPropertyDescriptor descriptor) {
        String name = descriptor.getDisplayName();
        Object id = descriptor.getId();
        if (id instanceof String && Objects.equal(name, id)) {
            name = PropertyDescriptors.capitalizeAndSplitCamelCase(name);
        }
        return name;
    }

    public static String getReadablePropertyName(PropertyDescriptor descriptor) {
        String id;
        String name = descriptor.getDisplayName();
        if (Objects.equal(name, id = descriptor.getName())) {
            name = PropertyDescriptors.capitalizeAndSplitCamelCase(name);
        }
        return name;
    }

    protected static String capitalizeAndSplitCamelCase(String name) {
        String name2 = Strings.splitCamelCase((String)name);
        name = Strings.capitalize((String)name2);
        return name;
    }

    public static Class<?> getPropertyType(IPropertyDescriptor descriptor) {
        if (descriptor instanceof ReturnType) {
            ReturnType rt = (ReturnType)descriptor;
            return rt.getReturnType();
        }
        if (descriptor instanceof TextPropertyDescriptor) {
            return String.class;
        }
        System.out.println("Unknown property type for " + descriptor + " of class: " + descriptor.getClass().getName() + " " + descriptor.getId());
        return String.class;
    }
}

