/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.tree;

import com.fusesource.rider.commons.tree.RefreshableUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Node
implements Comparable {
    protected Node parent;
    private List<Node> children = new ArrayList<Node>();

    public Node(Node parent) {
        this.parent = parent;
    }

    public Node addChild(Node node) {
        if (!this.children.contains(node)) {
            this.children.add(node);
            Collections.sort(this.children);
            return node;
        }
        return this.children.get(this.children.indexOf(node));
    }

    public boolean removeChild(Node child) {
        return this.children.remove(child);
    }

    public Node[] getChildren() {
        return this.children.toArray(new Node[this.children.size()]);
    }

    public List<Node> getChildrenList() {
        return this.children;
    }

    public Node getParent() {
        return this.parent;
    }

    public void clearChildren() {
        this.children.clear();
    }

    protected RefreshableUI getRefreshableUI() {
        if (this instanceof RefreshableUI) {
            return (RefreshableUI)((Object)this);
        }
        if (this.parent != null) {
            return this.parent.getRefreshableUI();
        }
        return null;
    }
}

