/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.tree;

import com.fusesource.rider.commons.Activator;
import com.fusesource.rider.commons.tree.GraphableNode;
import com.fusesource.rider.commons.tree.HasChildrenArray;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PartialRefreshableNode<K, V>
extends RefreshableCollectionNode
implements GraphableNode,
HasChildrenArray {
    protected List<V> list = new ArrayList<V>();
    private Map<K, V> childMap = new HashMap();
    private Set<V> addedNodes = new HashSet<V>();
    private Set<V> nodesToRemove = new HashSet<V>();

    public PartialRefreshableNode(Node parent) {
        super(parent);
    }

    @Override
    protected void loadChildren() {
        this.addedNodes.clear();
        this.nodesToRemove.clear();
        this.nodesToRemove.addAll(this.list);
        this.doLoadChildren();
        this.list.removeAll(this.nodesToRemove);
    }

    @Override
    public List<Node> getChildrenGraph() {
        ArrayList<Node> answer = new ArrayList<Node>();
        return answer;
    }

    @Override
    protected void refreshUI() {
        RefreshableUI ui = this.getRefreshableUI();
        if (ui != null) {
            if (!this.addedNodes.isEmpty() || !this.nodesToRemove.isEmpty()) {
                ArrayList<V> list = new ArrayList<V>();
                list.addAll(this.addedNodes);
                list.addAll(this.nodesToRemove);
                for (Object node : list) {
                    ui.fireRefresh(node, false);
                }
                ui.fireRefresh(this, false);
            }
        } else {
            Activator.getLogger().warning("Could not find RefreshableUI for " + this);
        }
    }

    protected abstract Object[] doLoadChildren();

    @Override
    public Object[] getChildObjectArray() {
        this.checkLoaded();
        return this.list.toArray();
    }

    protected void addChild(K key, V connectionWrapper) {
        this.childMap.put(key, connectionWrapper);
        this.list.add(connectionWrapper);
        this.addedNodes.add(connectionWrapper);
    }

    protected boolean nodeStillExists(V connectionWrapper) {
        return this.nodesToRemove.remove(connectionWrapper);
    }

    protected V getChild(K key) {
        return this.childMap.get(key);
    }
}

