/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.tree;

import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableNode;
import com.fusesource.rider.commons.ui.propsrc.PropertySourceTableSheetPage;
import com.fusesource.rider.commons.ui.views.ViewPropertySheetPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public abstract class RefreshableCollectionNode
extends RefreshableNode
implements IAdaptable {
    public RefreshableCollectionNode(Node parent) {
        super(parent);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySourceTablePage();
        }
        return null;
    }

    public ViewPropertySheetPage getPropertySourceTablePage() {
        List<IPropertySource> list = this.getPropertySourceList();
        if (!list.isEmpty()) {
            PropertySourceTableSheetPage view = this.createPropertySourceTableSheetPage();
            view.setPropertySources(list);
            return view;
        }
        return null;
    }

    protected PropertySourceTableSheetPage createPropertySourceTableSheetPage() {
        return new PropertySourceTableSheetPage(this, this.getClass().getName());
    }

    public List<IPropertySource> getPropertySourceList() {
        ArrayList<IPropertySource> list = new ArrayList<IPropertySource>();
        List<Node> children = this.getChildrenList();
        for (Node node : children) {
            IPropertySourceProvider provider;
            IPropertySource propertySource = null;
            if (node instanceof IPropertySourceProvider && (propertySource = (provider = (IPropertySourceProvider)node).getPropertySource((Object)node)) != null) {
                list.add(propertySource);
            }
            if (propertySource != null || !(node instanceof RefreshableCollectionNode)) continue;
            RefreshableCollectionNode coll = (RefreshableCollectionNode)node;
            list.addAll(coll.getPropertySourceList());
        }
        return list;
    }

    public int getChildCount() {
        Node[] children = this.getChildren();
        if (children != null) {
            return children.length;
        }
        return 0;
    }
}

