/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.tree;

import com.fusesource.rider.commons.Activator;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.NodeSupport;
import com.fusesource.rider.commons.tree.Refreshable;
import com.fusesource.rider.commons.tree.RefreshableUI;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class RefreshableNode
extends NodeSupport
implements Refreshable {
    private AtomicBoolean loaded = new AtomicBoolean(false);
    private boolean loading;

    public RefreshableNode(Node parent) {
        super(parent);
    }

    @Override
    public void refresh() {
        this.clearChildren();
        this.loadChildren();
        this.refreshUI();
    }

    @Override
    public boolean removeChild(Node child) {
        boolean answer = super.removeChild(child);
        if (answer) {
            this.refreshParentUI();
        }
        return answer;
    }

    protected void refreshUI() {
        RefreshableUI ui = this.getRefreshableUI();
        if (ui != null) {
            ui.fireRefresh(this, false);
        } else {
            Activator.getLogger().warning("Could not find RefreshableUI for " + this);
        }
    }

    protected void refreshParentUI() {
        Node p = this.getParent();
        if (p instanceof RefreshableNode) {
            RefreshableNode pr = (RefreshableNode)p;
            pr.refreshUI();
        } else {
            this.refreshUI();
        }
    }

    protected void refreshParent() {
        Node p = this.getParent();
        if (p instanceof RefreshableNode) {
            RefreshableNode refreshableNode = (RefreshableNode)p;
            refreshableNode.refresh();
        } else {
            this.refresh();
        }
    }

    @Override
    public Node[] getChildren() {
        this.checkLoaded();
        return super.getChildren();
    }

    @Override
    public List<Node> getChildrenList() {
        this.checkLoaded();
        return super.getChildrenList();
    }

    protected void checkLoaded() {
        if (this.loaded.compareAndSet(false, true)) {
            this.loading = true;
            try {
                try {
                    this.loadChildren();
                    this.refreshUIAfterLazyLoad();
                }
                catch (Exception e) {
                    Activator.getLogger().warning("Failed to load children of " + this + ". " + e, e);
                    this.loading = false;
                }
            }
            finally {
                this.loading = false;
            }
        }
    }

    protected void refreshUIAfterLazyLoad() {
    }

    protected boolean isLoading() {
        return this.loading;
    }

    protected abstract void loadChildren();
}

