/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui;

import com.fusesource.rider.commons.Viewers;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class Widgets {
    public static void dispose(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            Widgets.removeListeners(widget, 10);
            widget.dispose();
        }
    }

    public static void removeListeners(Widget widget, int eventType) {
        Listener[] listeners;
        Listener[] listenerArray = listeners = widget.getListeners(eventType);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            widget.removeListener(eventType, listener);
            ++n2;
        }
    }

    public static Button createActionButton(Composite parent, Action action) {
        ActionContributionItem aci = new ActionContributionItem((IAction)action);
        aci.fill(parent);
        Button button = (Button)aci.getWidget();
        if (button != null) {
            button.setText(action.getText());
        }
        return button;
    }

    public static void refresh(Viewer v) {
        Viewers.refresh(v);
    }

    public static boolean isValid(Widget widget) {
        if (widget == null || widget.isDisposed()) {
            return false;
        }
        Display display = widget.getDisplay();
        if (display == null) {
            return false;
        }
        if (display.getThread() != Thread.currentThread()) {
            return false;
        }
        return !widget.isDisposed();
    }

    public static boolean isValidFromOtherThread(Widget widget) {
        if (widget == null || widget.isDisposed()) {
            return false;
        }
        Display display = widget.getDisplay();
        if (display == null) {
            return false;
        }
        return !widget.isDisposed();
    }

    public static void setDoubleClickAction(StructuredViewer viewer, final Action doubleClickAction) {
        if (doubleClickAction != null) {
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (doubleClickAction.isEnabled()) {
                        doubleClickAction.run();
                    }
                }
            });
        }
    }

    public static boolean isDisposed(Control control) {
        return control != null && control.isDisposed();
    }
}

