/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.chart;

import com.fusesource.rider.commons.ui.actions.Messages;
import com.fusesource.rider.commons.ui.chart.TableChartColumnInfo;
import com.fusesource.rider.commons.ui.config.ColumnConfiguration;
import com.fusesource.rider.commons.ui.views.ColumnViewSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ViewSettingsDialog;

public class TableChartDialog
extends ViewSettingsDialog {
    CheckboxTableViewer columnsViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private final ColumnViewSupport tableView;

    public TableChartDialog(ColumnViewSupport tableView) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.tableView = tableView;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.createChartTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createColumnsViewer(inner);
        this.createButtons(inner);
        this.loadPreference();
        TableChartDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        System.out.println("About to open chart!!!");
        super.okPressed();
    }

    protected void performDefaults() {
        this.columnsViewer.refresh();
    }

    private void createColumnsViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.configureColumnsMessage);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.columnsViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67586);
        this.columnsViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.columnsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TableChartColumnInfo) {
                    TableChartColumnInfo col = (TableChartColumnInfo)element;
                    return col.getName();
                }
                return super.getText(element);
            }
        });
        this.columnsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.selectAllButton = new Button(composite, 8);
        this.selectAllButton.setText(Messages.selectAllLabel);
        this.setButtonLayoutData(this.selectAllButton);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableChartDialog.this.columnsViewer.setAllChecked(true);
            }
        });
        this.deselectAllButton = new Button(composite, 8);
        this.deselectAllButton.setText(Messages.deselectAllLabel);
        this.setButtonLayoutData(this.deselectAllButton);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableChartDialog.this.columnsViewer.setAllChecked(false);
            }
        });
    }

    private void loadPreference() {
        List<TableChartColumnInfo> columnList = this.tableView.getChartOptions().getNumericColumns();
        ArrayList checkedList = new ArrayList(columnList.size());
        Iterator<TableChartColumnInfo> iterator = columnList.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        this.columnsViewer.setInput(columnList);
        this.columnsViewer.setCheckedElements(checkedList.toArray());
    }

    private void storePreference() {
        new HashSet<Object>(Arrays.asList(this.columnsViewer.getCheckedElements()));
    }

    private List<ColumnConfiguration> getColumns() {
        return (List)this.columnsViewer.getInput();
    }

    protected List selectedList() {
        return ((IStructuredSelection)this.columnsViewer.getSelection()).toList();
    }
}

