/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.config;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.osgi.service.prefs.Preferences;

public class ColumnConfiguration {
    private final String name;
    private final Preferences node;
    private CellLabelProvider labelProvider;

    public ColumnConfiguration(String name, Preferences node) {
        this.name = name;
        this.node = node;
    }

    public String toString() {
        return "ColumnConfiguration(" + this.name + ")";
    }

    public String getName() {
        return this.name;
    }

    public Preferences getNode() {
        return this.node;
    }

    public boolean isVisible() {
        return this.node.getBoolean("visible", true);
    }

    public String getDescription() {
        return this.node.get("description", this.name);
    }

    public void setVisible(boolean value) {
        if (value) {
            this.node.remove("visible");
        } else {
            this.node.putBoolean("visible", value);
        }
    }

    public int getWidth() {
        return this.node.getInt("width", 0);
    }

    public void setWidth(int value) {
        if (value <= 0) {
            this.node.remove("width");
        } else {
            this.node.putInt("width", value);
        }
    }

    public String getLabelProviderStyle() {
        return this.node.get("labelProviderStyle", null);
    }

    public void setLabelProviderStyle(String value) {
        this.node.put("labelProviderStyle", value);
    }

    public CellLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(CellLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }
}

