/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.config;

import com.fusesource.rider.commons.Activator;
import com.fusesource.rider.commons.IFlushable;
import com.fusesource.rider.commons.PreferencesHelper;
import com.fusesource.rider.commons.ui.IConfigurableColumns;
import com.fusesource.rider.commons.ui.Tables;
import com.fusesource.rider.commons.ui.config.ColumnConfiguration;
import com.fusesource.rider.commons.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.service.prefs.Preferences;
import scala.actors.threadpool.AtomicInteger;

public class TableConfiguration
implements IFlushable {
    protected static final int CONFIG_UPDATE_ONMOVE_DELAY = 1500;
    protected static final String COLUMN_NAME_SEPARATOR = ",";
    protected static final String COLUMN_ORDER = "columnOrder";
    private static AtomicInteger moveEventCounter = new AtomicInteger();
    private static Map<String, TableConfiguration> defaultCache = new HashMap<String, TableConfiguration>();
    private List<ColumnConfiguration> columnConfigurations;
    private Map<String, ColumnConfiguration> columnMap;
    private final Preferences node;
    private boolean cleared;

    public TableConfiguration(Preferences node) {
        this.node = node;
    }

    public String toString() {
        return "TableConfguration(" + this.node + ")";
    }

    public static TableConfiguration loadDefault(Class<?> aClass) {
        return TableConfiguration.loadDefault(aClass.getName());
    }

    public static synchronized TableConfiguration loadDefault(String className) {
        TableConfiguration answer = defaultCache.get(className);
        if (answer == null) {
            Preferences node = PreferencesHelper.defaultNode(className, "tableColumns");
            answer = new TableConfiguration(node);
            defaultCache.put(className, answer);
        }
        return answer;
    }

    public static TableConfiguration loadConfiguration(Class<?> aClass) {
        return TableConfiguration.loadConfiguration(aClass.getName());
    }

    public static TableConfiguration loadConfiguration(String className) {
        TableConfiguration defaults = TableConfiguration.loadDefault(className);
        Preferences node = PreferencesHelper.configurationNode(className, "tableColumns");
        TableConfiguration answer = new TableConfiguration(node);
        answer.addDefaults(defaults);
        return answer;
    }

    @Override
    public void flush() {
        PreferencesHelper.flush(this.node);
    }

    public void clear() {
        this.cleared = true;
        try {
            Preferences parent = this.node.parent();
            this.node.removeNode();
            if (parent != null) {
                PreferencesHelper.flush(parent);
            }
        }
        catch (Exception e) {
            Activator.getLogger().error("Failed to clear " + this + ". " + e, e);
        }
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public void reload() {
        this.columnConfigurations = null;
    }

    public boolean hasColumns() {
        return this.getColumnConfigurations().size() > 0;
    }

    public ColumnConfiguration column(String name) {
        return this.column(name, this.node.node(name));
    }

    public ColumnConfiguration column(String name, Preferences node) {
        ColumnConfiguration config = this.getConfiguration(name);
        if (config == null) {
            config = new ColumnConfiguration(name, node);
            this.addColumn(config);
        }
        return config;
    }

    protected ColumnConfiguration addColumn(ColumnConfiguration config) {
        this.getColumnConfigurations().add(config);
        this.updateColumnOrder(this.columnConfigurations);
        this.flushIndexes();
        return config;
    }

    public List<ColumnConfiguration> getColumnConfigurations() {
        if (this.columnConfigurations == null) {
            this.loadConfigurations();
        }
        return this.columnConfigurations;
    }

    protected void loadConfigurations() {
        ArrayList<ColumnConfiguration> list = new ArrayList<ColumnConfiguration>();
        String text = this.node.get(COLUMN_ORDER, "");
        if (text != null && text.length() > 0) {
            String[] childrenNames;
            String[] stringArray = childrenNames = text.split(COLUMN_NAME_SEPARATOR);
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                ColumnConfiguration config = new ColumnConfiguration(name, this.node.node(name));
                list.add(config);
                ++n2;
            }
        }
        this.setColumnConfigurations(list);
    }

    public void setColumnConfigurations(List<ColumnConfiguration> columnConfigurations) {
        List<String> names = this.updateColumnOrder(columnConfigurations);
        if (this.columnConfigurations != null) {
            for (ColumnConfiguration oldConfig : this.columnConfigurations) {
                String name = oldConfig.getName();
                if (names.contains(name)) continue;
                this.node.remove(name);
            }
        }
        this.columnConfigurations = columnConfigurations;
        this.flushIndexes();
    }

    protected List<String> updateColumnOrder(List<ColumnConfiguration> columnConfigurations) {
        List<String> names = this.getColumnNames(columnConfigurations);
        String columnOrderText = Strings.join(COLUMN_NAME_SEPARATOR, names.toArray());
        this.node.put(COLUMN_ORDER, columnOrderText);
        return names;
    }

    private List<String> getColumnNames(List<ColumnConfiguration> list) {
        ArrayList<String> answer = new ArrayList<String>();
        for (ColumnConfiguration config : list) {
            answer.add(config.getName());
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushIndexes() {
        TableConfiguration tableConfiguration = this;
        synchronized (tableConfiguration) {
            this.columnMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ColumnConfiguration> getColumnMap() {
        TableConfiguration tableConfiguration = this;
        synchronized (tableConfiguration) {
            List<ColumnConfiguration> list = this.getColumnConfigurations();
            if (this.columnMap == null) {
                this.columnMap = new HashMap<String, ColumnConfiguration>();
                for (ColumnConfiguration column : list) {
                    this.columnMap.put(column.getName(), column);
                }
            }
            return this.columnMap;
        }
    }

    public ColumnConfiguration getConfiguration(String columnName) {
        return this.getColumnMap().get(columnName);
    }

    public List<String> sortDefaultColumnNames(Collection<String> columnNames) {
        HashSet<String> existing = new HashSet<String>(columnNames);
        ArrayList<String> answer = new ArrayList<String>();
        List<ColumnConfiguration> list = this.getColumnConfigurations();
        for (ColumnConfiguration config : list) {
            String name = config.getName();
            if (!existing.contains(name)) continue;
            answer.add(name);
        }
        for (String name : columnNames) {
            if (answer.contains(name)) continue;
            answer.add(name);
        }
        return answer;
    }

    public void addDefaultColumns(List<String> columns) {
        for (String name : columns) {
            this.column(name);
        }
    }

    public void addDefaults(TableConfiguration defaults) {
        List<ColumnConfiguration> list = defaults.getColumnConfigurations();
        for (ColumnConfiguration column : list) {
            this.defaultColumn(column);
        }
    }

    public void defaultColumn(ColumnConfiguration defaultValues) {
        CellLabelProvider labelProvider;
        String labelProviderStyle;
        int width;
        ColumnConfiguration current = this.getConfiguration(defaultValues.getName());
        if (current == null) {
            current = this.addColumn(defaultValues);
        }
        if ((width = defaultValues.getWidth()) > 0 && current.getWidth() == 0) {
            current.setWidth(width);
        }
        if ((labelProviderStyle = defaultValues.getLabelProviderStyle()) != null) {
            current.setLabelProviderStyle(labelProviderStyle);
        }
        if ((labelProvider = defaultValues.getLabelProvider()) != null) {
            current.setLabelProvider(labelProvider);
        }
    }

    public void onColumnsMoved(TableViewer viewer) {
        if (this.isCleared() || viewer.getTable() == null || viewer.getTable().isDisposed()) {
            return;
        }
        Table table = viewer.getTable();
        ArrayList<ColumnConfiguration> newOrder = new ArrayList<ColumnConfiguration>();
        TableColumn[] columns = Tables.getColumns(viewer);
        if (columns.length > 0) {
            int[] columnOrder;
            int[] nArray = columnOrder = table.getColumnOrder();
            int n = columnOrder.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column;
                int idx = nArray[n2];
                if (idx >= 0 && idx < columns.length && (column = columns[idx]) != null && !column.isDisposed()) {
                    String name = column.getText();
                    ColumnConfiguration config = this.column(name);
                    newOrder.add(config);
                }
                ++n2;
            }
        }
        if (columns.length > 1 && newOrder.size() > 1) {
            this.makeOtherColumnsInvisilbe(newOrder);
            System.out.println("Flushing column configuration with newOrder: " + newOrder + " and columns: " + columns.length);
            this.flush();
        }
    }

    public void onColumnsMoved(TreeViewer viewer) {
        int[] columnOrder;
        if (this.isCleared() || viewer.getTree() == null || viewer.getTree().isDisposed()) {
            return;
        }
        Tree table = viewer.getTree();
        ArrayList<ColumnConfiguration> newOrder = new ArrayList<ColumnConfiguration>();
        TreeColumn[] columns = table.getColumns();
        int[] nArray = columnOrder = table.getColumnOrder();
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column;
            int idx = nArray[n2];
            if (idx >= 0 && idx < columns.length && (column = columns[idx]) != null && !column.isDisposed()) {
                String name = column.getText();
                ColumnConfiguration config = this.column(name);
                newOrder.add(config);
            }
            ++n2;
        }
        this.makeOtherColumnsInvisilbe(newOrder);
        this.flush();
    }

    protected void makeOtherColumnsInvisilbe(List<ColumnConfiguration> newOrder) {
        HashSet<ColumnConfiguration> addedColumns = new HashSet<ColumnConfiguration>(newOrder);
        List<ColumnConfiguration> list = this.getColumnConfigurations();
        for (ColumnConfiguration config : list) {
            if (addedColumns.contains(config)) continue;
            config.setVisible(false);
            newOrder.add(config);
        }
        this.setColumnConfigurations(newOrder);
    }

    public void addListener(IConfigurableColumns configurableColumns) {
    }

    public void removeListener(IConfigurableColumns configurableColumns) {
    }

    public void addColumnListeners(TableViewer viewer) {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = viewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            this.addColumnListeners(viewer, column);
            ++n2;
        }
    }

    public void addColumnListeners(TreeViewer viewer) {
        TreeColumn[] columns;
        TreeColumn[] treeColumnArray = columns = viewer.getTree().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            this.addColumnListeners(viewer, column);
            ++n2;
        }
    }

    protected void addColumnListeners(final TableViewer viewer, TableColumn column) {
        column.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                final int value = moveEventCounter.incrementAndGet();
                Display.getCurrent().timerExec(1500, new Runnable(){

                    @Override
                    public void run() {
                        if (moveEventCounter.compareAndSet(value, 0)) {
                            TableConfiguration.this.onColumnsMoved(viewer);
                        }
                    }
                });
            }
        });
    }

    protected void addColumnListeners(final TreeViewer viewer, TreeColumn column) {
        column.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                final int value = moveEventCounter.incrementAndGet();
                Display.getCurrent().timerExec(1500, new Runnable(){

                    @Override
                    public void run() {
                        if (moveEventCounter.compareAndSet(value, 0)) {
                            TableConfiguration.this.onColumnsMoved(viewer);
                        }
                    }
                });
            }
        });
    }
}

