/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.drop;

import com.fusesource.rider.commons.ui.drop.DropHandler;
import com.fusesource.rider.commons.ui.drop.DropHandlerFactory;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class DropHandlerSupport
implements DropHandler {
    public static boolean isSupported(Transfer transfer, TransferData[] dataTypes) {
        TransferData[] transferDataArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData data = transferDataArray[n2];
            if (transfer.isSupportedType(data)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static DropHandler createDropHandler(Object target, DropTargetEvent event) {
        if (target instanceof DropHandler) {
            return (DropHandler)target;
        }
        if (target instanceof DropHandlerFactory) {
            DropHandlerFactory factory = (DropHandlerFactory)target;
            return factory.createDropHandler(event);
        }
        return null;
    }

    @Override
    public void drop(DropTargetEvent event) {
        Object data = event.data;
        if (DropHandlerSupport.isSupported((Transfer)FileTransfer.getInstance(), event.dataTypes)) {
            if (data instanceof Object[]) {
                if (data instanceof Object[]) {
                    Object[] array;
                    Object[] objectArray = array = (Object[])data;
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        this.dropFile(object);
                        ++n2;
                    }
                } else if (data instanceof Collection) {
                    Collection coll = (Collection)data;
                    for (Object object : coll) {
                        this.dropFile(object);
                    }
                } else {
                    this.dropFile(data);
                }
            } else {
                this.dropFile(data);
            }
        } else {
            this.dropObject(data);
        }
    }

    protected void dropFile(Object object) {
        File file = null;
        if (object instanceof String) {
            String fileName = (String)object;
            file = new File(fileName);
        } else if (object instanceof File) {
            file = (File)object;
        } else if (object instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)object;
            for (Object element : selection) {
                this.dropFile(element);
            }
        } else if (object instanceof IFile) {
            IFile ifile = (IFile)object;
            this.dropIFile(ifile);
        } else {
            this.unknownType("File", object);
        }
        if (file != null) {
            this.dropFile(file);
        }
    }

    public void dropObject(Object data) {
        if (data instanceof Object[]) {
            Object[] array;
            Object[] objectArray = array = (Object[])data;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.dropObject(object);
                ++n2;
            }
        } else if (data instanceof Collection) {
            Collection coll = (Collection)data;
            for (Object object : coll) {
                this.dropObject(object);
            }
        } else if (data instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)data;
            for (Object element : selection) {
                this.dropObject(element);
            }
        } else if (data instanceof IFile) {
            IFile ifile = (IFile)data;
            this.dropIFile(ifile);
        } else {
            this.unknownType("Object", data);
        }
    }

    public void unknownType(String kind, Object data) {
    }

    public abstract void dropIFile(IFile var1);

    public abstract void dropFile(File var1);
}

