/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.form;

import com.fusesource.rider.commons.ui.form.FormSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class FormPage
extends Page {
    private FormSupport form;
    private Composite control;

    public FormPage(FormSupport form) {
        this.form = form;
    }

    public FormSupport getForm() {
        return this.form;
    }

    public void init(final IPageSite pageSite) {
        super.init(pageSite);
        ISelectionProvider selectionProvider = pageSite.getSelectionProvider();
        if (selectionProvider != null && this.form instanceof ISelectionListener) {
            final ISelectionListener listener = (ISelectionListener)this.form;
            selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object source = event.getSource();
                    IWorkbenchPart part = null;
                    part = source instanceof IWorkbenchPart ? (IWorkbenchPart)source : pageSite.getPage().getActivePart();
                    listener.selectionChanged(part, event.getSelection());
                }
            });
        }
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout());
        this.form.createDialogArea(this.control);
    }

    public void dispose() {
        this.form.dispose();
        super.dispose();
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.form.setFocus();
    }
}

