/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.label;

import com.fusesource.rider.commons.Activator;
import java.text.DateFormat;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;

public class FormatLabelProvider
extends StyledCellLabelProvider {
    private DateFormat format;

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element != null) {
            try {
                DateFormat f = this.getFormat();
                if (f != null) {
                    String text = "";
                    Object convertValue = this.convertValue(cell);
                    if (convertValue != null) {
                        text = f.format(convertValue);
                    }
                    cell.setText(text);
                }
            }
            catch (Exception e) {
                Activator.getLogger().warning("Failed to format " + element + " of type " + element.getClass().getName() + " using formatter: " + this.format + ". " + e, e);
            }
        }
        super.update(cell);
    }

    public DateFormat getFormat() {
        if (this.format == null) {
            this.format = this.createFormat();
        }
        return this.format;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    protected DateFormat createFormat() {
        return null;
    }

    protected Object convertValue(ViewerCell cell) {
        return cell.getText();
    }
}

