/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.propsrc;

import com.fusesource.rider.commons.tree.HasOwner;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.Refreshable;
import com.fusesource.rider.commons.tree.Refreshables;
import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.propsrc.PropertySourceTableView;
import com.fusesource.rider.commons.ui.views.ViewPropertySheetPage;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertySourceTableSheetPage
extends ViewPropertySheetPage
implements Refreshable {
    private PropertySourceTableView tableView;
    private final Node owner;

    public PropertySourceTableSheetPage(Node owner, String viewId) {
        this(owner, viewId, new PropertySourceTableView(viewId));
    }

    public PropertySourceTableSheetPage(Node ownerNode, String viewId, PropertySourceTableView tableView) {
        this.owner = ownerNode;
        this.tableView = tableView;
        this.setView(tableView);
        tableView.setDoubleClickAction(new Action(){

            public void run() {
                Object first = Selections.getFirstSelection((Viewer)PropertySourceTableSheetPage.this.getTableView().getViewer());
                if (first != null && PropertySourceTableSheetPage.this.owner instanceof HasRefreshableUI) {
                    if (first instanceof HasOwner) {
                        HasOwner ho = (HasOwner)first;
                        first = ho.getOwner();
                    }
                    HasRefreshableUI hr = (HasRefreshableUI)((Object)PropertySourceTableSheetPage.this.owner);
                    Selections.setSingleSelection(hr.getRefreshableUI(), first);
                }
            }
        });
    }

    public List<?> getPropertySources() {
        return this.tableView.getPropertySources();
    }

    public void setPropertySources(List<IPropertySource> propertySources) {
        this.tableView.setPropertySources(propertySources);
    }

    public PropertySourceTableView getTableView() {
        return this.tableView;
    }

    @Override
    public void refresh() {
        Refreshables.refresh(this.getTableView());
    }
}

