/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.propsrc;

import com.fusesource.rider.commons.properties.PropertyDescriptors;
import com.fusesource.rider.commons.ui.label.FunctionColumnLabelProvider;
import com.fusesource.rider.commons.ui.views.TreeViewSupport;
import com.fusesource.rider.commons.util.Function1;
import com.fusesource.rider.commons.util.Function1WithReturnType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertySourceTreeView
extends TreeViewSupport
implements IPropertySheetPage {
    public static final String ID = "com.fusesource.ide.fabric.views.PropertySourceTableView";
    private List<IPropertySource> propertySources = new ArrayList<IPropertySource>();
    private final String viewId;

    public PropertySourceTreeView(String viewId) {
        this.viewId = viewId;
    }

    public List<IPropertySource> getPropertySources() {
        return this.propertySources;
    }

    public void setPropertySources(List<IPropertySource> propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public String getId() {
        return this.viewId;
    }

    @Override
    protected String getHelpID() {
        return ID;
    }

    @Override
    public void createControl(Composite parent) {
        this.createPartControl(parent);
    }

    @Override
    public Control getControl() {
        return this.getViewer().getControl();
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    @Override
    public void setActionBars(IActionBars actionBars) {
    }

    @Override
    protected void createColumns() {
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        TreeMap<String, 1> headers = new TreeMap<String, 1>();
        for (IPropertySource propertySource : this.propertySources) {
            IPropertyDescriptor[] descriptors = propertySource.getPropertyDescriptors();
            if (descriptors == null) continue;
            IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                final IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                final Object id = descriptor.getId();
                String name = PropertyDescriptors.getReadablePropertyName(descriptor);
                Function1WithReturnType function = new Function1WithReturnType(){

                    @Override
                    public Object apply(Object object) {
                        if (object instanceof IPropertySource) {
                            IPropertySource property = (IPropertySource)object;
                            return property.getPropertyValue(id);
                        }
                        return null;
                    }

                    @Override
                    public Class<?> getReturnType() {
                        return PropertyDescriptors.getPropertyType(descriptor);
                    }
                };
                headers.put(name, function);
                ++n2;
            }
        }
        Set entrySet = headers.entrySet();
        for (Map.Entry entry : entrySet) {
            String header = (String)entry.getKey();
            Function1 function = (Function1)entry.getValue();
            this.addFunction(function);
            TreeViewerColumn col = this.createTreeViewerColumn(header, bounds, column++);
            col.setLabelProvider((CellLabelProvider)new FunctionColumnLabelProvider(function));
        }
    }

    @Override
    protected void configureViewer() {
        this.viewer.setInput(this.propertySources);
    }

    @Override
    protected ITreeContentProvider createContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return PropertySourceTreeView.this.propertySources.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        };
    }
}

