/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.views;

import com.fusesource.rider.commons.Activator;
import com.fusesource.rider.commons.ui.views.IViewPage;
import com.fusesource.rider.commons.ui.views.ViewPropertySheetPage;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PageSection
implements ISection {
    private final IPage page;
    private TabbedPropertySheetPage tabbedSheetPage;
    private IWorkbenchPart part;
    private ISelection selection;

    public PageSection(IPage page) {
        this.page = page;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedSheetPage) {
        this.tabbedSheetPage = tabbedSheetPage;
        System.out.println("Creating page controls for " + this.page);
        IPageSite pageSite = this.getPageSite();
        if (pageSite != null) {
            if (this.page instanceof IPageBookViewPage) {
                IPageBookViewPage pageBookViewPage = (IPageBookViewPage)this.page;
                try {
                    pageBookViewPage.init(pageSite);
                }
                catch (PartInitException e) {
                    Activator.getLogger().warning("Failed to initialise page: " + pageBookViewPage + ". " + (Object)((Object)e), e);
                }
            } else if (this.page instanceof IViewPage) {
                IViewPage viewPage = (IViewPage)this.page;
                viewPage.init(pageSite);
            }
        }
        this.page.createControl(parent);
    }

    protected IPageSite getPageSite() {
        IPageSite pageSite = null;
        if (this.tabbedSheetPage != null) {
            pageSite = this.tabbedSheetPage.getSite();
        }
        return pageSite;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.part = part;
        this.selection = selection;
        if (this.page instanceof ISelectionListener) {
            ISelectionListener sl = (ISelectionListener)this.page;
            sl.selectionChanged(part, selection);
        }
    }

    public void aboutToBeShown() {
        if (this.page instanceof ISelectionListener) {
            ISelectionListener sl = (ISelectionListener)this.page;
            sl.selectionChanged(this.part, this.selection);
        }
        try {
            ViewPropertySheetPage sheetPage;
            IViewPage viewPage;
            if (this.page instanceof ViewPropertySheetPage && (viewPage = (sheetPage = (ViewPropertySheetPage)this.page).getView()) instanceof ISection) {
                ISection section = (ISection)viewPage;
                section.aboutToBeShown();
            }
        }
        catch (Throwable t) {
            Activator.getLogger().warning("aboutToBeShown() Failed with: " + t, t);
        }
    }

    public void aboutToBeHidden() {
        try {
            ViewPropertySheetPage sheetPage;
            IViewPage viewPage;
            if (this.page instanceof ViewPropertySheetPage && (viewPage = (sheetPage = (ViewPropertySheetPage)this.page).getView()) instanceof ISection) {
                ISection section = (ISection)viewPage;
                section.aboutToBeHidden();
            }
        }
        catch (Throwable t) {
            Activator.getLogger().warning("aboutToBeHidden() Failed with: " + t, t);
        }
    }

    protected IMenuManager getMenuManager() {
        IActionBars actionBars = this.getActionBars();
        IMenuManager menuManager = null;
        if (actionBars != null) {
            menuManager = actionBars.getMenuManager();
        }
        return menuManager;
    }

    protected IToolBarManager getToolBarManager() {
        IActionBars actionBars = this.getActionBars();
        IToolBarManager answer = null;
        if (actionBars != null) {
            answer = actionBars.getToolBarManager();
        }
        return answer;
    }

    protected IActionBars getActionBars() {
        IPageSite pageSite = this.getPageSite();
        IActionBars actionBars = null;
        if (pageSite != null) {
            actionBars = pageSite.getActionBars();
        }
        return actionBars;
    }

    public void dispose() {
        this.page.dispose();
    }

    public int getMinimumHeight() {
        return 0;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
    }
}

