/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.views;

import com.fusesource.rider.commons.ui.views.PageSection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;

public abstract class PageTabDescriptor
extends AbstractTabDescriptor {
    private static final AtomicLong counter = new AtomicLong(0L);
    private final String label;
    private final String category;

    public PageTabDescriptor(String label) {
        this(label, "Fuse");
    }

    public PageTabDescriptor(String label, String category) {
        this.label = label;
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public List<ISectionDescriptor> getSectionDescriptors() {
        ArrayList<ISectionDescriptor> list = new ArrayList<ISectionDescriptor>();
        list.add(this.createSectionDescriptor());
        return list;
    }

    protected ISectionDescriptor createSectionDescriptor() {
        return new AbstractSectionDescriptor(){

            public boolean appliesTo(IWorkbenchPart part, ISelection selection) {
                return true;
            }

            public String getId() {
                return PageTabDescriptor.this.getId();
            }

            public ISection getSectionClass() {
                IPage page = PageTabDescriptor.this.createPage();
                if (page instanceof ISection) {
                    return (ISection)page;
                }
                return new PageSection(page);
            }

            public String getTargetTab() {
                return PageTabDescriptor.this.label;
            }
        };
    }

    protected abstract IPage createPage();
}

