/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.ui.views;

import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.ui.Trees;
import com.fusesource.rider.commons.ui.Widgets;
import com.fusesource.rider.commons.ui.chart.TableChartColumnInfo;
import com.fusesource.rider.commons.ui.chart.TableChartOptions;
import com.fusesource.rider.commons.ui.config.ColumnConfiguration;
import com.fusesource.rider.commons.ui.config.TableConfiguration;
import com.fusesource.rider.commons.ui.label.FunctionColumnLabelProvider;
import com.fusesource.rider.commons.ui.label.WrappedCellLabelProvider;
import com.fusesource.rider.commons.ui.views.ColumnViewSupport;
import com.fusesource.rider.commons.ui.views.TextTreeViewFilter;
import com.fusesource.rider.commons.util.Function1;
import com.fusesource.rider.commons.util.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public abstract class TreeViewSupport
extends ColumnViewSupport {
    protected TreeViewer viewer;
    private Composite parent;
    private TextTreeViewFilter filter = new TextTreeViewFilter();
    private ColumnViewSupport.ColumnFunctionComparator comparator = new ColumnViewSupport.ColumnFunctionComparator();
    private List<String> columnNames;

    protected abstract void createColumns();

    protected abstract void configureViewer();

    protected abstract ITreeContentProvider createContentProvider();

    @Override
    public List<String> getColumns() {
        if (this.columnNames == null) {
            Tree table;
            this.columnNames = new ArrayList<String>();
            if (this.viewer != null && (table = this.viewer.getTree()) != null) {
                TreeColumn[] tableColumns;
                TreeColumn[] treeColumnArray = tableColumns = table.getColumns();
                int n = tableColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    try {
                        String name = column.getText();
                        this.columnNames.add(name);
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
        }
        return this.columnNames;
    }

    @Override
    public void updateColumnConfiguration(TableConfiguration configuration) {
        this.setConfiguration(configuration);
        Trees.disposeColumns(this.viewer);
        this.recreateColumns();
        this.getViewer().refresh(true);
    }

    protected void recreateColumns() {
        this.createColumns();
        this.columnNames = null;
        this.getColumns();
        this.getConfiguration().addColumnListeners(this.getViewer());
        this.reorderColumns();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        Label searchLabel = new Label(parent, 0);
        searchLabel.setText("Search: ");
        final Text searchText = new Text(parent, 2176);
        searchText.setLayoutData((Object)new GridData(768));
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                TreeViewSupport.this.filter.setSearchText(searchText.getText());
                TreeViewSupport.this.onFilterChanged();
            }
        });
        this.createViewer();
        this.makeActions();
    }

    protected void onFilterChanged() {
        Viewers.refresh((Viewer)this.viewer);
    }

    protected void createViewer() {
        if (this.viewer != null) {
            this.viewer.getControl().dispose();
        }
        this.viewer = new TreeViewer(this.parent, 68354);
        Tree table = this.viewer.getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        ITreeContentProvider contentProvider = this.createContentProvider();
        this.filter.setContentProvider(contentProvider);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.recreateColumns();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.configureViewer();
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.chartOptions = this.createChartOptions();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getHelpSystem().setHelp(this.viewer.getControl(), this.getHelpID());
        this.hookDoubleClickAction();
        this.parent.layout(true);
    }

    private void reorderColumns() {
        if (this.getConfiguration() == null || !this.getConfiguration().hasColumns()) {
            return;
        }
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>();
        ArrayList<String> columnNameOrderList = new ArrayList<String>();
        ArrayList<Integer> columnOrderList = new ArrayList<Integer>();
        TreeColumn[] columnArray = Trees.getColumns(this.viewer);
        Tree table = this.viewer.getTree();
        int i = 0;
        int size = columnArray.length;
        while (i < size) {
            TreeColumn column = columnArray[i];
            String name = column.getText();
            columnMap.put(name, column);
            columnIndexes.put(name, i);
            ++i;
        }
        List<ColumnConfiguration> list = this.getConfiguration().getColumnConfigurations();
        for (ColumnConfiguration config : list) {
            Integer index;
            String columnName = config.getName();
            boolean columnVisibility = config.isVisible();
            TreeColumn column = (TreeColumn)columnMap.get(columnName);
            if (!columnVisibility) {
                Widgets.dispose((Widget)column);
                continue;
            }
            if (column == null) {
                System.out.println("No column found for name '" + columnName + "'");
                continue;
            }
            columnNameOrderList.add(columnName);
            int width = config.getWidth();
            if (width > 0) {
                column.setWidth(width);
            }
            if ((index = (Integer)columnIndexes.get(columnName)) == null) continue;
            int idx = index;
            CellLabelProvider oldLabelProvider = this.getCellLabelProvider(idx);
            TreeViewerColumn viewerColumn = Trees.getTreeViewerColumn(column);
            this.configureLabelProvider((ViewerColumn)viewerColumn, config, oldLabelProvider);
        }
        columnArray = table.getColumns();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int i2 = 0;
        int size2 = columnArray.length;
        while (i2 < size2) {
            TreeColumn column = columnArray[i2];
            String name = column.getText();
            indexMap.put(name, i2);
            ++i2;
        }
        for (String columnName : columnNameOrderList) {
            Integer i3 = (Integer)indexMap.get(columnName);
            if (i3 == null) {
                System.out.println("Warning no column index for name '" + columnName + "' found!");
                continue;
            }
            columnOrderList.add(i3);
        }
        int[] columnOrder = table.getColumnOrder();
        int i4 = 0;
        int size3 = columnOrder.length;
        while (i4 < size3) {
            TreeColumn column;
            int idx = columnOrder[i4];
            Integer key = idx;
            if (idx >= 0 && idx < columnArray.length && !columnOrderList.contains(key) && (column = columnArray[i4]) != null && !column.isDisposed()) {
                columnOrderList.add(key);
            }
            ++i4;
        }
        int[] newColumnOrder = new int[columnOrderList.size()];
        int idx = 0;
        for (Integer key : columnOrderList) {
            newColumnOrder[idx++] = key;
        }
        table.setColumnOrder(newColumnOrder);
    }

    @Override
    protected TableChartOptions createChartOptions() {
        TableChartOptions options = new TableChartOptions();
        Tree table = this.viewer.getTree();
        int i = 0;
        int size = table.getColumnCount();
        while (i < size) {
            CellLabelProvider labelProvider = this.getCellLabelProvider(i);
            Class<?> returnType = Objects.getReturnType(labelProvider);
            if (Objects.isNumberType(returnType)) {
                TreeColumn column = table.getColumn(i);
                options.addNumericColumn(new TableChartColumnInfo((Item)column, labelProvider));
            }
            ++i;
        }
        return options;
    }

    protected CellLabelProvider getCellLabelProvider(int idx) {
        CellLabelProvider oldLabelProvider = this.viewer.getLabelProvider(idx);
        if (oldLabelProvider instanceof WrappedCellLabelProvider) {
            WrappedCellLabelProvider wrapped = (WrappedCellLabelProvider)oldLabelProvider;
            oldLabelProvider = wrapped.getWrappedLabelProvider();
        }
        return oldLabelProvider;
    }

    protected TreeViewerColumn createTreeViewerColumn(String title, int bound, int colNumber) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber));
        return viewerColumn;
    }

    protected int addColumnFunction(int bounds, int column, Function1 function, String columnName, CellLabelProvider labelProvider) {
        this.addFunction(function);
        TreeViewerColumn col = this.createTreeViewerColumn(columnName, bounds, column++);
        col.setLabelProvider(labelProvider);
        return column;
    }

    protected int addColumnFunction(int bounds, int column, Function1 function, String columnName) {
        return this.addColumnFunction(bounds, column, function, columnName, (CellLabelProvider)new FunctionColumnLabelProvider(function));
    }

    protected SelectionAdapter getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewSupport.this.comparator.setColumn(index);
                if (Viewers.isValid((Viewer)TreeViewSupport.this.viewer)) {
                    int dir = TreeViewSupport.this.viewer.getTree().getSortDirection();
                    dir = TreeViewSupport.this.viewer.getTree().getSortColumn() == column ? (dir == 128 ? 1024 : 128) : 1024;
                    TreeViewSupport.this.viewer.getTree().setSortDirection(dir);
                    TreeViewSupport.this.viewer.getTree().setSortColumn(column);
                    TreeViewSupport.this.viewer.refresh();
                }
            }
        };
        return selectionAdapter;
    }

    @Override
    protected void showChartDialog() {
    }

    public Tree getTree() {
        return this.viewer.getTree();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

