/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.commons.util;

import com.fusesource.rider.commons.util.ReturnType;
import com.fusesource.rider.commons.util.Strings;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class Objects {
    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    public static int compare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static String typeName(Object value) {
        return value == null ? "null" : value.getClass().getCanonicalName();
    }

    public static <T> T[] getArrayOf(Collection<?> coll, Class<T> aType) {
        ArrayList<T> answer = new ArrayList<T>(coll.size());
        for (Object element : coll) {
            if (!aType.isInstance(element)) continue;
            answer.add(aType.cast(element));
        }
        Object[] array = (Object[])Array.newInstance(aType, answer.size());
        return answer.toArray(array);
    }

    public static void notNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(message) + " should not be null");
        }
    }

    public static <T> T getField(Object instance, String fieldName, Class<? extends Object> aClass) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = Objects.getFieldDescriptor(instance, fieldName, aClass);
        return (T)field.get(instance);
    }

    public static Field getFieldDescriptor(Object instance, String fieldName) throws NoSuchFieldException {
        Class<?> aClass = instance.getClass();
        while (true) {
            try {
                return Objects.getFieldDescriptor(instance, fieldName, aClass);
            }
            catch (NoSuchFieldException e) {
                Class<?> superclass;
                if (aClass != Object.class && (superclass = aClass.getSuperclass()) != null && superclass != Object.class && superclass != aClass) {
                    aClass = superclass;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static Field getFieldDescriptor(Object instance, String fieldName, Class<? extends Object> aClass) throws NoSuchFieldException {
        Objects.notNull(instance, "instance");
        Field field = aClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static Method getMethodDescriptor(Object instance, String methodName, Class<? extends Object> aClass, Class<?> ... parameters) throws NoSuchMethodException {
        Objects.notNull(instance, "instance");
        Method method = aClass.getDeclaredMethod(methodName, parameters);
        method.setAccessible(true);
        return method;
    }

    public static Class<?> getReturnType(Object object) {
        if (object instanceof ReturnType) {
            ReturnType rt = (ReturnType)object;
            return rt.getReturnType();
        }
        return null;
    }

    public static boolean isNumberType(Class<?> aType) {
        if (aType != null && aType != Boolean.TYPE && aType != Boolean.class) {
            return aType.isPrimitive() || Number.class.isAssignableFrom(aType);
        }
        return false;
    }

    public static void setField(Object owner, String name, Object newValue, Class<?> definedIn) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = Objects.getFieldDescriptor(owner, name, definedIn);
        field.set(owner, newValue);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static Integer parseInt(String text) {
        if (!Strings.isBlank(text)) {
            return Integer.parseInt(text);
        }
        return null;
    }

    public static String makeString(String prefix, String separator, String postfix, Object[] values) {
        StringBuilder buffer = new StringBuilder(prefix);
        boolean first = true;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(object);
            ++n2;
        }
        buffer.append(postfix);
        return buffer.toString();
    }

    public static String makeString(String prefix, String separator, String postfix, long[] values) {
        StringBuilder buffer = new StringBuilder(prefix);
        boolean first = true;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long object = lArray[n2];
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append("" + object);
            ++n2;
        }
        buffer.append(postfix);
        return buffer.toString();
    }

    public static String makeString(String prefix, String separator, String postfix, Iterable<?> values) {
        StringBuilder buffer = new StringBuilder(prefix);
        boolean first = true;
        for (Object object : values) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(object);
        }
        buffer.append(postfix);
        return buffer.toString();
    }
}

