/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fon.util.messages;

import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.commons.util.TextFilter;
import com.fusesource.rider.commons.util.TextFilters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.fusesource.camel.rider.util.XmlHelper;
import org.fusesource.fon.util.messages.BinaryBody;
import org.fusesource.fon.util.messages.Body;
import org.fusesource.fon.util.messages.BodyType;
import org.fusesource.fon.util.messages.Header;
import org.fusesource.fon.util.messages.IMessage;
import org.fusesource.fon.util.messages.PreMarshalHook;

@XmlRootElement(name="message")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Message
implements IMessage,
TextFilter,
PreMarshalHook {
    @XmlElementWrapper(name="headers", required=false)
    @XmlElement(name="header", required=false)
    private List<Header> headerList;
    @XmlElement(name="body", required=false)
    private Body textBodyMarkup;
    @XmlElement(name="binaryBody", required=false)
    private BinaryBody binaryBodyMarkup;
    @XmlAttribute(required=false)
    private String id;
    @XmlAttribute(required=false)
    private Long uuid;
    @XmlAttribute(required=false)
    private String toNode;
    @XmlAttribute(required=false)
    private Date timestamp;
    @XmlAttribute(required=false)
    private String endpointUri;
    @XmlAttribute(required=false)
    private Long relativeTime;
    @XmlAttribute(required=false)
    private Long elapsedTime;
    @XmlAttribute(required=false)
    private Integer exchangeIndex;
    @XmlTransient
    private Map<String, Object> headers;
    @XmlTransient
    private Object bodyValue;
    @XmlTransient
    private BodyType bodyMarkup;

    public Message() {
    }

    public Message(Object body) {
        this.bodyValue = body;
    }

    public String toString() {
        return "Message[headers=" + (this.headers != null ? this.headers : (this.headerList != null ? this.headerList : "")) + ", body=" + (this.bodyValue != null ? this.bodyValue : (this.textBodyMarkup != null ? this.textBodyMarkup : this.binaryBodyMarkup)) + "]";
    }

    @Override
    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
            if (this.headerList != null) {
                for (Header header : this.headerList) {
                    String name = header.getName();
                    Object value = header.getValue();
                    if (name == null || value == null) continue;
                    this.headers.put(name, value);
                }
            }
        }
        return this.headers;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = Strings.getOrElse(this.getHeaders().get("JMSMessageId"), null);
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Long getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(Long uuid) {
        this.uuid = uuid;
    }

    @Override
    public Object getBody() {
        if (this.bodyValue == null) {
            if (this.textBodyMarkup != null) {
                String text = this.textBodyMarkup.getValue();
                if (text != null) {
                    text = XmlHelper.unescape((String)text);
                }
                this.bodyValue = text;
            } else if (this.binaryBodyMarkup != null) {
                this.bodyValue = this.binaryBodyMarkup.getValue();
            }
        }
        return this.bodyValue;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void clearCachedBody() {
        this.bodyValue = null;
    }

    public void setBody(Object body) {
        this.bodyValue = body;
        if (body instanceof byte[]) {
            this.binaryBodyMarkup = new BinaryBody((byte[])body);
        } else {
            this.textBodyMarkup = new Body(body);
        }
    }

    public List<Header> getHeaderList() {
        if (this.headerList == null) {
            this.headerList = new ArrayList<Header>();
            Set<Map.Entry<String, Object>> entrySet = this.getHeaders().entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                Object value = entry.getValue();
                if (value == null) continue;
                this.headerList.add(new Header(entry.getKey(), value));
            }
        }
        return this.headerList;
    }

    public void setHeaderList(List<Header> headerList) {
        this.headerList = headerList;
    }

    public BodyType getBodyMarkup() {
        return this.bodyMarkup;
    }

    public void setBodyMarkup(Body bodyMarkup) {
        this.bodyMarkup = bodyMarkup;
    }

    @Override
    public String getToNode() {
        return this.toNode;
    }

    @Override
    public void setToNode(String toNode) {
        this.toNode = toNode;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Long getRelativeTime() {
        return this.relativeTime;
    }

    @Override
    public void setRelativeTime(Long elapsedTime) {
        this.relativeTime = elapsedTime;
    }

    @Override
    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public void setElapsedTime(Long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    @Override
    public Integer getExchangeIndex() {
        return this.exchangeIndex;
    }

    @Override
    public void setExchangeIndex(Integer exchangeIndex) {
        this.exchangeIndex = exchangeIndex;
    }

    @Override
    public String getEndpointUri() {
        return this.endpointUri;
    }

    @Override
    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    @Override
    public boolean matches(String searchText) {
        return TextFilters.matches(searchText, this.getBody()) || TextFilters.matches(searchText, this.getToNode()) || TextFilters.matches(searchText, this.getHeaders());
    }

    @Override
    public void preMarshal() {
        if (this.headers != null) {
            this.headerList = null;
            this.getHeaderList();
        }
    }

    public void setHeader(String name, String value) {
        this.addHeader(new Header(name, value));
    }

    public void addHeader(Header header) {
        this.getHeaderList().add(header);
    }
}

