/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.sampledb.ui.profile;

import java.util.Properties;
import org.eclipse.birt.report.data.bidi.utils.core.BidiFormat;
import org.eclipse.birt.report.data.oda.sampledb.SampleDBJDBCConnectionFactory;
import org.eclipse.birt.report.data.oda.sampledb.ui.i18n.Messages;
import org.eclipse.birt.report.data.oda.sampledb.ui.plugin.SampledbUIPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SampleDbSelectionPageHelper {
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private static final String SAMPLE_DB_SCHEMA = "ClassicModels";
    private final String CONEXT_ID_DATASOURCE_SAMPLEDB = "org.eclipse.birt.cshelp.Wizard_DatasourceProfile_ID";
    private Label m_driverClass;
    private Label m_driverURL;
    private Label m_sampleUser;
    static final String DEFAULT_MESSAGE = Messages.getMessage("datasource.page.title");
    private static final String EMPTY_STRING = "";
    private static final String EXTERNAL_BIDI_FORMAT = "report.data.oda.bidi.jdbc.ui.externalbidiformat";

    SampleDbSelectionPageHelper(WizardPage page) {
        this.m_wizardPage = page;
    }

    SampleDbSelectionPageHelper(PreferencePage page) {
        this.m_propertyPage = page;
    }

    void createCustomControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        new Label(content, 16384).setText(Messages.getMessage("datasource.page.driver.class"));
        this.m_driverClass = new Label(content, 16384);
        this.m_driverClass.setText("org.eclipse.birt.report.data.oda.sampledb.Driver");
        new Label(content, 16384).setText(Messages.getMessage("datasource.page.url"));
        this.m_driverURL = new Label(content, 16384);
        this.m_driverURL.setText("jdbc:classicmodels:sampledb");
        new Label(content, 16384).setText(Messages.getMessage("datasource.page.user"));
        this.m_sampleUser = new Label(content, 16384);
        this.m_sampleUser.setText(SampleDBJDBCConnectionFactory.getDbUser());
        this.setMessage(DEFAULT_MESSAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_DatasourceProfile_ID");
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("odaDriverClass", this.getDriverClass());
        props.setProperty("odaURL", this.getDriverUrl());
        props.setProperty("odaUser", SAMPLE_DB_SCHEMA);
        props.setProperty("odaPassword", EMPTY_STRING);
        props.setProperty("OdaConnProfileStorePath", EMPTY_STRING);
        BidiFormat externalDefaultBDiFormat = new BidiFormat(SampledbUIPlugin.getDefault().getPluginPreferences().getString(EXTERNAL_BIDI_FORMAT));
        if (externalDefaultBDiFormat != null) {
            props.setProperty("contentBidiFormatStr", externalDefaultBDiFormat.getBiDiFormatString());
            props.setProperty("metadataBidiFormatStr", externalDefaultBDiFormat.getBiDiFormatString());
        }
        return props;
    }

    private String getDriverClass() {
        return "org.eclipse.birt.report.data.oda.sampledb.Driver";
    }

    private String getDriverUrl() {
        return "jdbc:classicmodels:sampledb";
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty()) {
            return;
        }
        String driverClass = profileProps.getProperty("odaDriverClass");
        if (driverClass == null) {
            driverClass = EMPTY_STRING;
        }
        this.m_driverClass.setText(driverClass);
        String driverUrl = profileProps.getProperty("odaURL");
        if (driverUrl == null) {
            driverUrl = EMPTY_STRING;
        }
        this.m_driverURL.setText(driverUrl);
        String user = profileProps.getProperty("odaUser");
        if (user == null) {
            user = EMPTY_STRING;
        }
        this.m_sampleUser.setText(user);
    }

    private void setMessage(String message) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message);
        }
    }

    private Control getControl() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getControl();
        }
        assert (this.m_propertyPage != null);
        return this.m_propertyPage.getControl();
    }
}

