/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.impl.UpdateCheckManager;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.AuthenticationSelector;
import org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;
import org.sonatype.aether.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=RemoteRepositoryManager.class, hint="default")
public class DefaultRemoteRepositoryManager
implements RemoteRepositoryManager,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private UpdateCheckManager updateCheckManager;
    @Requirement(role=RepositoryConnectorFactory.class)
    private List<RepositoryConnectorFactory> connectorFactories = new ArrayList<RepositoryConnectorFactory>();
    private static final Comparator<RepositoryConnectorFactory> COMPARATOR = new Comparator<RepositoryConnectorFactory>(){

        @Override
        public int compare(RepositoryConnectorFactory o1, RepositoryConnectorFactory o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };

    public DefaultRemoteRepositoryManager() {
    }

    public DefaultRemoteRepositoryManager(Logger logger, UpdateCheckManager updateCheckManager, List<RepositoryConnectorFactory> connectorFactories) {
        this.setLogger(logger);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorFactories(connectorFactories);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
        this.setUpdateCheckManager((UpdateCheckManager)locator.getService(UpdateCheckManager.class));
        this.connectorFactories = locator.getServices(RepositoryConnectorFactory.class);
    }

    public DefaultRemoteRepositoryManager setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultRemoteRepositoryManager setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        if (updateCheckManager == null) {
            throw new IllegalArgumentException("update check manager has not been specified");
        }
        this.updateCheckManager = updateCheckManager;
        return this;
    }

    public DefaultRemoteRepositoryManager addRepositoryConnectorFactory(RepositoryConnectorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("repository connector factory has not been specified");
        }
        this.connectorFactories.add(factory);
        return this;
    }

    public DefaultRemoteRepositoryManager setRepositoryConnectorFactories(List<RepositoryConnectorFactory> factories) {
        this.connectorFactories = factories == null ? new ArrayList<RepositoryConnectorFactory>() : factories;
        return this;
    }

    @Override
    public List<RemoteRepository> aggregateRepositories(RepositorySystemSession session, List<RemoteRepository> dominantRepositories, List<RemoteRepository> recessiveRepositories, boolean recessiveIsRaw) {
        if (recessiveRepositories.isEmpty()) {
            return dominantRepositories;
        }
        MirrorSelector mirrorSelector = session.getMirrorSelector();
        AuthenticationSelector authSelector = session.getAuthenticationSelector();
        ProxySelector proxySelector = session.getProxySelector();
        ArrayList<RemoteRepository> result = new ArrayList<RemoteRepository>(dominantRepositories);
        Iterator<RemoteRepository> i$ = recessiveRepositories.iterator();
        block0: while (i$.hasNext()) {
            RemoteRepository recessiveRepository;
            RemoteRepository repository = recessiveRepository = i$.next();
            if (recessiveIsRaw) {
                RemoteRepository mirrorRepository = mirrorSelector.getMirror(recessiveRepository);
                repository = mirrorRepository != null ? mirrorRepository : recessiveRepository;
            }
            String key = this.getKey(repository);
            ListIterator<RemoteRepository> it = result.listIterator();
            while (it.hasNext()) {
                RemoteRepository mergedRepository;
                RemoteRepository dominantRepository = (RemoteRepository)it.next();
                if (!key.equals(this.getKey(dominantRepository))) continue;
                if (dominantRepository.getMirroredRepositories().isEmpty() || repository.getMirroredRepositories().isEmpty() || (mergedRepository = this.mergeMirrors(session, dominantRepository, repository)) == dominantRepository) continue block0;
                it.set(mergedRepository);
                continue block0;
            }
            if (recessiveIsRaw) {
                repository.setAuthentication(authSelector.getAuthentication(repository));
                repository.setProxy(proxySelector.getProxy(repository));
            }
            result.add(repository);
        }
        return result;
    }

    private String getKey(RemoteRepository repository) {
        return repository.getId();
    }

    private RemoteRepository mergeMirrors(RepositorySystemSession session, RemoteRepository dominant, RemoteRepository recessive) {
        RemoteRepository merged = dominant;
        block0: for (RemoteRepository rec : recessive.getMirroredRepositories()) {
            String recKey = this.getKey(rec);
            for (RemoteRepository dom : dominant.getMirroredRepositories()) {
                if (!recKey.equals(this.getKey(dom))) continue;
                continue block0;
            }
            if (merged == dominant) {
                merged = new RemoteRepository();
                merged.setRepositoryManager(dominant.isRepositoryManager());
                merged.setId(dominant.getId());
                merged.setContentType(dominant.getContentType());
                merged.setUrl(dominant.getUrl());
                merged.setAuthentication(dominant.getAuthentication());
                merged.setProxy(dominant.getProxy());
                merged.setPolicy(false, dominant.getPolicy(false));
                merged.setPolicy(true, dominant.getPolicy(true));
                merged.setMirroredRepositories(new ArrayList(dominant.getMirroredRepositories()));
            }
            merged.setPolicy(false, this.merge(session, merged.getPolicy(false), rec.getPolicy(false)));
            merged.setPolicy(true, this.merge(session, merged.getPolicy(true), rec.getPolicy(true)));
            merged.getMirroredRepositories().add(rec);
        }
        return merged;
    }

    @Override
    public RepositoryPolicy getPolicy(RepositorySystemSession session, RemoteRepository repository, boolean releases, boolean snapshots) {
        RepositoryPolicy policy = releases && snapshots ? this.merge(session, repository.getPolicy(false), repository.getPolicy(true)) : repository.getPolicy(snapshots);
        if (!StringUtils.isEmpty((String)session.getChecksumPolicy())) {
            policy = policy.setChecksumPolicy(session.getChecksumPolicy());
        }
        if (!StringUtils.isEmpty((String)session.getUpdatePolicy())) {
            policy = policy.setUpdatePolicy(session.getUpdatePolicy());
        }
        return policy;
    }

    private RepositoryPolicy merge(RepositorySystemSession session, RepositoryPolicy policy1, RepositoryPolicy policy2) {
        RepositoryPolicy policy;
        if (policy1.isEnabled() && policy2.isEnabled()) {
            String checksums = this.ordinalOfChecksumPolicy(policy2.getChecksumPolicy()) < this.ordinalOfChecksumPolicy(policy1.getChecksumPolicy()) ? policy2.getChecksumPolicy() : policy1.getChecksumPolicy();
            String updates = this.updateCheckManager.getEffectiveUpdatePolicy(session, policy1.getUpdatePolicy(), policy2.getUpdatePolicy());
            policy = new RepositoryPolicy(true, updates, checksums);
        } else {
            policy = policy2.isEnabled() ? policy2 : policy1;
        }
        return policy;
    }

    private int ordinalOfChecksumPolicy(String policy) {
        if ("fail".equals(policy)) {
            return 2;
        }
        if ("ignore".equals(policy)) {
            return 0;
        }
        return 1;
    }

    @Override
    public RepositoryConnector getRepositoryConnector(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        if (repository == null) {
            throw new IllegalArgumentException("remote repository has not been specified");
        }
        ArrayList<RepositoryConnectorFactory> factories = new ArrayList<RepositoryConnectorFactory>(this.connectorFactories);
        Collections.sort(factories, COMPARATOR);
        for (RepositoryConnectorFactory factory : factories) {
            try {
                RepositoryConnector connector = factory.newInstance(session, repository);
                if (this.logger.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(connector.getClass().getSimpleName());
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" as ").append(auth.getUsername());
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" as ").append(auth.getUsername());
                        }
                    }
                    this.logger.debug(buffer.toString());
                }
                return connector;
            }
            catch (NoRepositoryConnectorException e) {
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("No connector available to access repository ");
        buffer.append(repository.getId());
        buffer.append(" (").append(repository.getUrl());
        buffer.append(") of type ").append(repository.getContentType());
        buffer.append(" using the available factories ");
        ListIterator it = factories.listIterator();
        while (it.hasNext()) {
            RepositoryConnectorFactory factory = (RepositoryConnectorFactory)it.next();
            buffer.append(factory.getClass().getSimpleName());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        throw new NoRepositoryConnectorException(repository, buffer.toString());
    }
}

