/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.tools;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IAgentLoadHandler;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.tools.IConstants;
import com.fusesource.ide.jvmmonitor.internal.tools.Messages;
import com.fusesource.ide.jvmmonitor.internal.tools.Tools;
import com.fusesource.ide.jvmmonitor.tools.Activator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class AgentLoadHandler
implements IAgentLoadHandler {
    private String agentJarPath;
    private boolean isAgentLoaded = false;

    public AgentLoadHandler() {
        this.searchAgentJar();
    }

    public void loadAgent(IActiveJvm jvm) throws JvmCoreException {
        block15: {
            if (this.agentJarPath == null) {
                return;
            }
            Tools tools = Tools.getInstance();
            Object virtualMachine = null;
            try {
                try {
                    virtualMachine = tools.invokeAttach(jvm.getPid());
                    tools.invokeLoadAgent(virtualMachine, this.agentJarPath, this.agentJarPath);
                    this.isAgentLoaded = true;
                }
                catch (JvmCoreException e) {
                    Activator.log(4, NLS.bind((String)Messages.loadAgentFailedMsg, (Object)this.agentJarPath), e);
                    if (virtualMachine != null) {
                        try {
                            tools.invokeDetach(virtualMachine);
                        }
                        catch (JvmCoreException jvmCoreException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (virtualMachine != null) {
                    try {
                        tools.invokeDetach(virtualMachine);
                    }
                    catch (JvmCoreException jvmCoreException) {}
                }
                throw throwable;
            }
            if (virtualMachine != null) {
                try {
                    tools.invokeDetach(virtualMachine);
                }
                catch (JvmCoreException jvmCoreException) {}
            }
        }
    }

    public boolean isAgentLoaded() {
        return this.isAgentLoaded;
    }

    private void searchAgentJar() {
        File agentJar;
        String installationLication;
        String corePluginPath;
        URL entry = com.fusesource.ide.jvmmonitor.core.Activator.getDefault().getBundle().getEntry("/");
        try {
            corePluginPath = FileLocator.resolve((URL)entry).getPath();
        }
        catch (IOException iOException) {
            Activator.log(4, Messages.corePluginNoFoundMsg, new Exception());
            return;
        }
        File corePlugin = new File(corePluginPath);
        if (!corePlugin.exists() && !(corePlugin = new File(String.valueOf(installationLication = Platform.getInstallLocation().getURL().getPath()) + corePluginPath)).exists()) {
            Activator.log(4, Messages.corePluginNoFoundMsg, new Exception());
        }
        if (!(agentJar = new File(corePlugin + IConstants.JVMMONITOR_AGENT_JAR)).exists()) {
            Activator.log(4, NLS.bind((String)Messages.agentJarNotFoundMsg, (Object)agentJar.getAbsolutePath()), new Exception());
        }
        this.agentJarPath = agentJar.getAbsolutePath();
        Activator.log(1, NLS.bind((String)Messages.agentJarFoundMsg, (Object)this.agentJarPath), new Exception());
    }
}

